/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition.configs;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.Logging;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.libs.boostedyaml.YamlDocument;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import java.io.File;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompetitionConversions {
    public void performCheck() {
        ConfigBase config;
        Section competitionSection;
        File competitionFile = new File(EvenMoreFish.getInstance().getDataFolder(), "competitions.yml");
        if (!competitionFile.exists() || !competitionFile.isFile()) {
            return;
        }
        EvenMoreFish.getInstance().getLogger().info("Performing automatic conversion of competition configs.");
        File competitionsDir = this.getCompetitionsDirectory();
        if (!competitionsDir.exists()) {
            competitionsDir.mkdirs();
        }
        if ((competitionSection = (config = new ConfigBase(competitionFile, (Plugin)EvenMoreFish.getInstance(), false)).getConfig().getSection("competitions")) == null) {
            this.finalizeConversion(config);
            return;
        }
        Section rewards = config.getConfig().getSection("rewards");
        Section leaderboard = config.getConfig().getSection("leaderboard");
        Section general = config.getConfig().getSection("general");
        for (String competitionKey : competitionSection.getRoutesAsStrings(false)) {
            Section section = competitionSection.getSection(competitionKey);
            if (section == null) continue;
            this.convertSectionToFile(section, general, leaderboard, rewards);
        }
        this.finalizeConversion(config);
    }

    private void finalizeConversion(@NotNull ConfigBase competitionsConfig) {
        File file = competitionsConfig.getFile();
        file.renameTo(new File(EvenMoreFish.getInstance().getDataFolder(), "competitions.yml.old"));
        file.delete();
        Logging.info(ComponentMessage.componentMessage("<yellow>Your competition configs have been automatically converted to the new format.").get());
    }

    private File getCompetitionsDirectory() {
        return new File(EvenMoreFish.getInstance().getDataFolder(), "competitions");
    }

    private void convertSectionToFile(@NotNull Section section, @Nullable Section general, @Nullable Section leaderboard, @Nullable Section rewards) {
        String id = section.getNameAsString();
        if (id == null) {
            return;
        }
        File file = new File(EvenMoreFish.getInstance().getDataFolder(), "competitions/" + id + ".yml");
        ConfigBase configBase = new ConfigBase(file, (Plugin)EvenMoreFish.getInstance(), false);
        YamlDocument config = configBase.getConfig();
        config.setAll(section.getRouteMappedValues(true));
        config.set("id", (Object)id);
        config.set("disabled", (Object)false);
        this.applyGeneralSection(config, general, leaderboard, rewards);
        configBase.save();
    }

    private void applyGeneralSection(@NotNull YamlDocument config, @Nullable Section general, @Nullable Section leaderboard, @Nullable Section rewards) {
        if (general != null) {
            for (String key : general.getRoutesAsStrings(true)) {
                if (config.contains(key)) continue;
                config.set(key, general.get(key));
            }
        }
        if (rewards != null && !config.contains("rewards")) {
            config.set("rewards", (Object)rewards);
        }
        if (leaderboard != null && !config.contains("leaderboard")) {
            config.set("leaderboard", (Object)leaderboard);
        }
    }
}

