/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition.configs;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.reward.Reward;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.configs.CompetitionFileUpdates;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.messages.EMFSingleMessage;
import java.io.File;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompetitionFile
extends ConfigBase {
    private final Logger logger = this.getPlugin().getLogger();

    public CompetitionFile(@NotNull File file) throws InvalidConfigurationException {
        super(file, (Plugin)EvenMoreFish.getInstance(), false);
        CompetitionFileUpdates.update(this);
        this.performRequiredConfigChecks();
    }

    public CompetitionFile(@NotNull String id, @NotNull CompetitionType type, int duration) {
        this.getConfig().set("id", (Object)id);
        this.getConfig().set("type", (Object)type.toString());
        this.getConfig().set("duration", (Object)duration);
    }

    private void performRequiredConfigChecks() throws InvalidConfigurationException {
        if (this.getConfig().getString("id") == null) {
            this.logger.warning("Competition invalid: 'id' missing in " + this.getFileName());
            throw new InvalidConfigurationException("An ID has not been found in " + this.getFileName() + ". Please correct this.");
        }
        String type = this.getConfig().getString("type");
        if (type == null || CompetitionType.getType(type) == null) {
            this.logger.warning("Competition invalid: 'type' missing in " + this.getFileName());
            throw new InvalidConfigurationException("A type has not been found in " + this.getFileName() + ". Please correct this.");
        }
        if (this.getConfig().getInt("duration", (Integer)-1) == -1) {
            this.logger.warning("Competition invalid: 'duration' missing in " + this.getFileName());
            throw new InvalidConfigurationException("A duration has not been found in " + this.getFileName() + ". Please correct this.");
        }
    }

    @NotNull
    public String getId() {
        return Objects.requireNonNull(this.getConfig().getString("id"));
    }

    public boolean isDisabled() {
        return this.getConfig().getBoolean("disabled");
    }

    @NotNull
    public CompetitionType getType() {
        return Objects.requireNonNull(CompetitionType.getType(this.getConfig().getString("type")));
    }

    @NotNull
    public List<String> getTimes() {
        return this.getConfig().getStringList("times");
    }

    @NotNull
    public Map<DayOfWeek, List<String>> getScheduledDays() {
        Section section = this.getConfig().getSection("days");
        HashMap<DayOfWeek, List<String>> dayMap = new HashMap<DayOfWeek, List<String>>();
        if (section == null) {
            return dayMap;
        }
        for (String dayStr : section.getRoutesAsStrings(false)) {
            DayOfWeek day = FishUtils.getDay(dayStr);
            if (day == null) continue;
            dayMap.put(day, section.getStringList(dayStr));
        }
        return dayMap;
    }

    public int getDuration() {
        return Math.max(1, this.getConfig().getInt("duration"));
    }

    @NotNull
    public List<String> getStartCommands() {
        String route = "start-commands";
        if (!this.getConfig().contains(route)) {
            return List.of();
        }
        if (this.getConfig().isList(route)) {
            return this.getConfig().getStringList(route);
        }
        return List.of(this.getConfig().getString(route));
    }

    @NotNull
    public List<DayOfWeek> getBlacklistedDays() {
        return this.getConfig().getStringList("blacklisted-days").stream().map(FishUtils::getDay).filter(Objects::nonNull).toList();
    }

    @NotNull
    public List<Rarity> getAllowedRarities() {
        return this.getConfig().getStringList("allowed-rarities").stream().map(FishManager.getInstance()::getRarity).filter(Objects::nonNull).toList();
    }

    public int getNumberNeeded() {
        return Math.max(1, this.getConfig().getInt("number-needed", (Integer)0));
    }

    public boolean shouldBroadcastOnlyRods() {
        return this.getConfig().getBoolean("broadcast-only-rods", (Boolean)true);
    }

    public int getBroadcastRange() {
        return this.getConfig().getInt("broadcast-range", (Integer)-1);
    }

    @NotNull
    public List<String> getLeaderboardColours() {
        return this.getConfig().getStringList("leaderboard", List.of("<gold>{name}</gold>", "<yellow>{name}</yellow>", "<gray>{name}</gray>", "<gray>{name}</gray>", "<#888888>{name}</#888888>"));
    }

    @NotNull
    public List<Long> getAlertTimes() {
        List<String> times = this.getAlertTimesAsStrings();
        ArrayList<Long> finalTimes = new ArrayList<Long>();
        for (String time : times) {
            String[] split = time.split(":");
            if (split.length != 2) {
                this.logger.severe(time + " is not formatted correctly. Use MM:SS.");
                continue;
            }
            try {
                long seconds = Long.parseLong(split[1]);
                finalTimes.add(seconds += Long.parseLong(split[0]) * 60L);
            }
            catch (NumberFormatException exception) {
                this.logger.severe("Could not turn " + time + " into an alert time. If you need support, feel free to join the discord server: https://discord.gg/9fRbqWTnHS");
            }
        }
        return finalTimes;
    }

    @NotNull
    public List<String> getAlertTimesAsStrings() {
        return this.getConfig().getStringList("alerts");
    }

    @NotNull
    public Map<Integer, List<Reward>> getRewards() {
        Section section = this.getConfig().getSection("rewards");
        if (section == null) {
            return Map.of();
        }
        HashMap<Integer, List<Reward>> rewardMap = new HashMap<Integer, List<Reward>>();
        for (String positionStr : section.getRoutesAsStrings(false)) {
            Integer position = positionStr.equalsIgnoreCase("participation") ? Integer.valueOf(-1) : FishUtils.getInteger(positionStr);
            if (position == null) continue;
            List<Reward> rewards = section.getStringList(positionStr).stream().map(Reward::new).toList();
            rewardMap.put(position, rewards);
        }
        return rewardMap;
    }

    @NotNull
    public BossBar.Color getBossbarColour() {
        String colour = this.getConfig().getString("bossbar-colour", "GREEN");
        try {
            return BossBar.Color.valueOf((String)colour.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            EvenMoreFish.getInstance().getLogger().warning(colour + " is not a valid bossbar colour. Defaulting to GREEN.");
            return BossBar.Color.GREEN;
        }
    }

    public boolean shouldShowBossbar() {
        return this.getConfig().getBoolean("show-bossbar", (Boolean)true);
    }

    public EMFSingleMessage getBossbarPrefix() {
        String prefix = this.getConfig().getString("bossbar-prefix", "<green><bold>Fishing Contest: ");
        return EMFSingleMessage.fromString(prefix);
    }

    public int getPlayersNeeded() {
        return Math.max(1, this.getConfig().getInt("minimum-players", (Integer)5));
    }

    @Nullable
    public Sound getStartSound() {
        String soundString = this.getConfig().getString("start-sound", "NONE");
        if (soundString.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            return Sound.valueOf((String)soundString.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            EvenMoreFish.getInstance().getLogger().warning(soundString + " is not a valid sound. Defaulting to NONE.");
            return null;
        }
    }

    public List<World> getRequiredWorlds() {
        return this.getConfig().getStringList("required-worlds").stream().map(Bukkit::getWorld).filter(Objects::nonNull).toList();
    }

    public boolean isAllowHunting() {
        return this.getConfig().getBoolean("allow-hunting", (Boolean)false);
    }

    public boolean isAllowFishing() {
        return this.getConfig().getBoolean("allow-fishing", (Boolean)true);
    }
}

