/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.config;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.gui.ConfigGui;
import com.oheers.fish.gui.GuiUtils;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.libs.inventorygui.GuiElement;
import com.oheers.fish.libs.inventorygui.StaticGuiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GuiFillerConfig
extends ConfigBase {
    private static GuiFillerConfig instance;

    public GuiFillerConfig() {
        super("gui-fillers.yml", "gui-fillers.yml", (Plugin)EvenMoreFish.getInstance(), true);
        instance = this;
    }

    public static GuiFillerConfig getInstance() {
        return instance;
    }

    public List<GuiElement> getDefaultFillerItems(@NotNull ConfigGui gui) {
        ArrayList<GuiElement> elements = new ArrayList<GuiElement>();
        this.getConfig().getRoutesAsStrings(false).forEach(key -> {
            Section itemSection = this.getConfig().getSection((String)key);
            if (itemSection == null || !itemSection.contains("item")) {
                return;
            }
            StaticGuiElement element = this.getGuiItem(gui, itemSection);
            if (element != null) {
                elements.add(element);
            }
        });
        return elements;
    }

    private StaticGuiElement getGuiItem(@NotNull ConfigGui gui, @NotNull Section itemSection) {
        char character = FishUtils.getCharFromString(itemSection.getString("character", "#"), '#');
        if (character == '#') {
            return null;
        }
        ItemFactory factory = ItemFactory.itemFactory(itemSection);
        ItemStack item = factory.createItem();
        if (item.getType() == Material.AIR) {
            return null;
        }
        Section actionSection = itemSection.getSection("click-action");
        if (actionSection != null) {
            return new StaticGuiElement(character, item, click -> {
                BiConsumer<ConfigGui, GuiElement.Click> action;
                switch (click.getType()) {
                    case LEFT: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = GuiUtils.getActionMap().get(actionSection.getString("left", ""));
                        break;
                    }
                    case RIGHT: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = GuiUtils.getActionMap().get(actionSection.getString("right", ""));
                        break;
                    }
                    case MIDDLE: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = GuiUtils.getActionMap().get(actionSection.getString("middle", ""));
                        break;
                    }
                    case DROP: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = GuiUtils.getActionMap().get(actionSection.getString("drop", ""));
                        break;
                    }
                    default: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = action = null;
                    }
                }
                if (action != null) {
                    action.accept(null, click);
                }
                return true;
            }, new String[0]);
        }
        return new StaticGuiElement(character, item, click -> {
            BiConsumer<ConfigGui, GuiElement.Click> action = GuiUtils.getActionMap().get(itemSection.getString("click-action", ""));
            if (action != null) {
                action.accept(gui, click);
            }
            return true;
        }, new String[0]);
    }
}

