/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.config;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.economy.EconomyType;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.libs.boostedyaml.route.Route;
import com.oheers.fish.libs.boostedyaml.settings.updater.UpdaterSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.bossbar.BossBar;
import org.apache.commons.lang3.LocaleUtils;
import org.bukkit.block.Biome;
import org.bukkit.boss.BarStyle;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainConfig
extends ConfigBase {
    private static MainConfig instance = null;
    private final boolean adminShortcutEnabled;
    private final String adminShortcutName;
    private final String mainCommandName;
    private final List<String> mainCommandAliases;
    private final String adminSubCommandName;
    private final String nextSubCommandName;
    private final String toggleSubCommandName;
    private final String guiSubCommandName;
    private final String helpSubCommandName;
    private final String topSubCommandName;
    private final String shopSubCommandName;
    private final String sellAllSubCommandName;
    private final String applyBaitsSubCommandName;
    private final String journalSubCommandName;

    public MainConfig() {
        super("config.yml", "config.yml", (Plugin)EvenMoreFish.getInstance(), true);
        instance = this;
        this.mainCommandName = this.getConfig().getString("command.main", "emf");
        this.mainCommandAliases = this.getConfig().getStringList("command.aliases");
        this.adminShortcutEnabled = this.getConfig().getBoolean("command.admin-shortcut.enabled", (Boolean)true);
        this.adminShortcutName = this.getConfig().getString("command.admin-shortcut.name", "emfa");
        this.adminSubCommandName = this.getConfig().getString("command.subcommands.admin", "admin");
        this.nextSubCommandName = this.getConfig().getString("command.subcommands.next", "next");
        this.toggleSubCommandName = this.getConfig().getString("command.subcommands.toggle", "toggle");
        this.guiSubCommandName = this.getConfig().getString("command.subcommands.gui", "gui");
        this.helpSubCommandName = this.getConfig().getString("command.subcommands.help", "help");
        this.topSubCommandName = this.getConfig().getString("command.subcommands.top", "top");
        this.shopSubCommandName = this.getConfig().getString("command.subcommands.shop", "shop");
        this.sellAllSubCommandName = this.getConfig().getString("command.subcommands.sellall", "sellall");
        this.applyBaitsSubCommandName = this.getConfig().getString("command.subcommands.applybaits", "applybaits");
        this.journalSubCommandName = this.getConfig().getString("command.subcommands.journal", "journal");
    }

    public static MainConfig getInstance() {
        return instance;
    }

    public String getLocale() {
        return this.getConfig().getString("locale", "en");
    }

    public boolean doingRandomDurability() {
        return this.getConfig().getBoolean("random-durability", (Boolean)true);
    }

    @Deprecated
    public boolean isDatabaseOnline() {
        if (!this.databaseEnabled() || EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().usingV2()) {
            return false;
        }
        return EvenMoreFish.getInstance().getPluginDataManager().getDatabase() != null;
    }

    public boolean isCatchEnabled() {
        return this.getConfig().getBoolean("fishing.catch-enabled", (Boolean)true);
    }

    public boolean isFishCatchOnlyInCompetition() {
        return this.getConfig().getBoolean("fishing.catch-only-in-competition", (Boolean)false);
    }

    public boolean isFishCatchOverrideOnlyFish() {
        return this.getConfig().getBoolean("fishing.only-fish", (Boolean)false);
    }

    public boolean isHuntEnabled() {
        return this.getConfig().getBoolean("fishing.hunt-enabled", (Boolean)false);
    }

    public boolean isFishHuntOnlyInCompetition() {
        return this.getConfig().getBoolean("fishing.hunt-only-in-competition", (Boolean)true);
    }

    public boolean isFishHuntIgnoreSpawnerFish() {
        return this.getConfig().getBoolean("fishing.hunt-ignore-spawner-fish", (Boolean)true);
    }

    public boolean isCompetitionUnique() {
        return this.getConfig().getBoolean("fish-only-in-competition", (Boolean)false);
    }

    public boolean getEnabled() {
        return this.getConfig().getBoolean("enabled", (Boolean)true);
    }

    public boolean worldWhitelist() {
        return !this.getConfig().getStringList("allowed-worlds").isEmpty();
    }

    public List<String> getAllowedRegions() {
        return this.getConfig().getStringList("allowed-regions");
    }

    public List<String> getAllowedWorlds() {
        return this.getConfig().getStringList("allowed-worlds");
    }

    public boolean shouldRespectVanish() {
        return this.getConfig().getBoolean("respect-vanished", (Boolean)true);
    }

    public boolean shouldProtectBaitedRods() {
        return this.getConfig().getBoolean("protect-baited-rods", (Boolean)true);
    }

    public BossBar.Overlay getBarStyle() {
        try {
            BarStyle style = BarStyle.valueOf((String)this.getConfig().getString("barstyle", "SEGMENTED_10"));
            return FishUtils.modernizeBarStyle(style);
        }
        catch (IllegalArgumentException exception) {
            return BossBar.Overlay.NOTCHED_10;
        }
    }

    public boolean sellOverDrop() {
        return this.getConfig().getBoolean("sell-gui.sell-over-drop", (Boolean)false);
    }

    public boolean disableMcMMOTreasure() {
        return this.getConfig().getBoolean("disable-mcmmo-loot", (Boolean)true);
    }

    public boolean disableAureliumSkills() {
        return this.getConfig().getBoolean("disable-aureliumskills-loot", (Boolean)true);
    }

    public boolean doDBVerbose() {
        return this.getConfig().getBoolean("disable-db-verbose", (Boolean)false) == false;
    }

    public boolean requireCustomRod() {
        return this.getConfig().getBoolean("fishing.require-custom-rod", (Boolean)false);
    }

    public boolean requireFishingPermission() {
        return this.getConfig().getBoolean("requires-fishing-permission", (Boolean)false);
    }

    public boolean blockCrafting() {
        return this.getConfig().getBoolean("item-protection.block-crafting", (Boolean)true);
    }

    public boolean blockConsume() {
        return this.getConfig().getBoolean("item-protection.block-consume", (Boolean)true);
    }

    public boolean blockFurnaceBurn() {
        return this.getConfig().getBoolean("item-protection.block-furnace-burn", (Boolean)true);
    }

    public boolean blockCooking() {
        return this.getConfig().getBoolean("item-protection.block-cooking", (Boolean)true);
    }

    public boolean blockPlacing() {
        return this.getConfig().getBoolean("item-protection.block-placing", (Boolean)true);
    }

    public boolean debugSession() {
        return this.getConfig().getBoolean("debug-session", (Boolean)false);
    }

    public boolean databaseEnabled() {
        return this.getConfig().getBoolean("database.enabled", (Boolean)false);
    }

    public String getAddress() {
        return this.getConfig().getString("database.address", "localhost");
    }

    public String getDatabase() {
        return this.getConfig().getString("database.database", "database");
    }

    public String getUsername() {
        return this.getConfig().getString("database.username", "root");
    }

    public String getPassword() {
        return this.getConfig().getString("database.password", "");
    }

    public String getPrefix() {
        return this.getConfig().getString("database.prefix", "emf_");
    }

    public String getDatabaseType() {
        return this.getConfig().getString("database.type", "sqlite");
    }

    public String getSaveIntervalUnit() {
        return this.getConfig().getString(Route.from("database", "advanced", "save-interval", "units"), "SECONDS");
    }

    public int getCompetitionSaveInterval() {
        return this.getSaveInterval("competition");
    }

    public int getUserFishStatsSaveInterval() {
        return this.getSaveInterval("user-fish-stats");
    }

    private int getSaveInterval(String path) {
        return this.getConfig().getInt(Route.from("database", "advanced", "save-interval", path), (Integer)5);
    }

    public boolean isDisableJooqStartupCommments() {
        return this.getConfig().getBoolean("database.advanced.disable-jooq-startup-comments", (Boolean)true);
    }

    public boolean useAdditionalAddons() {
        return this.getConfig().getBoolean("addons.additional-addons", (Boolean)true);
    }

    public Locale getDecimalLocale() {
        String locale = this.getConfig().getString(Route.fromString("decimal-locale"), "en-US");
        return LocaleUtils.toLocale((String)locale);
    }

    public int getNearbyPlayersRequirementRange() {
        return this.getConfig().getInt("requirement.nearby-players.range", (Integer)0);
    }

    public boolean isAdminShortcutCommandEnabled() {
        return this.adminShortcutEnabled;
    }

    public String getAdminShortcutCommandName() {
        return this.adminShortcutName;
    }

    public String getMainCommandName() {
        return this.mainCommandName;
    }

    public List<String> getMainCommandAliases() {
        return this.mainCommandAliases;
    }

    public String getAdminSubCommandName() {
        return this.adminSubCommandName;
    }

    public String getNextSubCommandName() {
        return this.nextSubCommandName;
    }

    public String getToggleSubCommandName() {
        return this.toggleSubCommandName;
    }

    public String getGuiSubCommandName() {
        return this.guiSubCommandName;
    }

    public String getHelpSubCommandName() {
        return this.helpSubCommandName;
    }

    public String getTopSubCommandName() {
        return this.topSubCommandName;
    }

    public String getShopSubCommandName() {
        return this.shopSubCommandName;
    }

    public String getSellAllSubCommandName() {
        return this.sellAllSubCommandName;
    }

    public String getApplyBaitsSubCommandName() {
        return this.applyBaitsSubCommandName;
    }

    public String getJournalSubCommandName() {
        return this.journalSubCommandName;
    }

    public boolean useOldBaseCommandBehavior() {
        return this.getConfig().getBoolean("command.old-base-command-behavior", (Boolean)false);
    }

    public boolean giveStraightToInventory() {
        return this.getConfig().getBoolean("give-straight-to-inventory");
    }

    public Map<String, List<Biome>> getBiomeSets() {
        HashMap<String, List<Biome>> biomeSetMap = new HashMap<String, List<Biome>>();
        Section section = this.getConfig().getSection("biome-sets");
        if (section == null) {
            return Map.of();
        }
        section.getRoutesAsStrings(false).forEach(key -> {
            ArrayList biomes = new ArrayList();
            section.getStringList((String)key).forEach(biomeString -> {
                Biome biome = FishUtils.getBiome(biomeString);
                if (biome == null) {
                    EvenMoreFish.getInstance().getLogger().severe(biomeString + " is not a valid biome, found when loading in biome set " + key + ".");
                }
                biomes.add(biome);
            });
            biomeSetMap.put((String)key, biomes);
        });
        return biomeSetMap;
    }

    public double getRegionBoost(String region, String rarity) {
        double defaultBoostRate = 1.0;
        if (region == null || rarity == null) {
            return defaultBoostRate;
        }
        Section regionBoosts = this.getConfig().getSection("region-boosts");
        if (regionBoosts == null) {
            return defaultBoostRate;
        }
        Section regionSection = regionBoosts.getSection(region);
        if (regionSection == null) {
            return defaultBoostRate;
        }
        return regionSection.getDouble(rarity, (Double)defaultBoostRate);
    }

    public boolean isRegionBoostsEnabled() {
        return this.getConfig().contains("region-boosts") && this.getConfig().isSection("region-boosts");
    }

    public boolean isEconomyEnabled(@NotNull EconomyType type) {
        return this.getConfig().getBoolean("economy." + type.getIdentifier().toLowerCase() + ".enabled");
    }

    public double getEconomyMultiplier(@NotNull EconomyType type) {
        return this.getConfig().getDouble("economy." + type.getIdentifier().toLowerCase() + ".multiplier");
    }

    @Nullable
    public String getEconomyDisplay(@NotNull EconomyType type) {
        return this.getConfig().getString("economy." + type.getIdentifier().toLowerCase() + ".display");
    }

    @Override
    public UpdaterSettings getUpdaterSettings() {
        return UpdaterSettings.builder(super.getUpdaterSettings()).addCustomLogic("1", document -> {
            String economyType = document.getString("economy-type");
            document.remove("enable-economy");
            document.remove("economy-type");
            if (economyType != null && !economyType.equalsIgnoreCase("NONE")) {
                String path = "economy." + economyType.toLowerCase();
                document.set(path + ".enabled", (Object)true);
            }
        }).addRelocation("1", "block-crafting", "item-protection.block-crafting", '.').addRelocation("1", "fish-only-in-competition", "fishing.catch-only-in-competition", '.').addCustomLogic("1", document -> {
            if (!document.contains("vanilla-fishing")) {
                return;
            }
            boolean vanillaFishing = document.getBoolean("vanilla-fishing");
            document.set("fishing.catch-enabled", (Object)(!vanillaFishing ? 1 : 0));
            document.remove("vanilla-fishing");
        }).addRelocation("2", "require-nbt-rod", "fishing.require-custom-rod", '.').build();
    }

    public boolean hasCredentials() {
        return MainConfig.getInstance().getUsername() != null && MainConfig.getInstance().getPassword() != null && MainConfig.getInstance().getAddress() != null && MainConfig.getInstance().getDatabase() != null;
    }

    public double getBaitBoostRate() {
        return this.getConfig().getDouble("bait.boost", (Double)1.5);
    }

    public boolean getBaitCompetitionDisable() {
        return this.getConfig().getBoolean("bait.competition-disable", (Boolean)true);
    }

    public boolean getBaitAddToLore() {
        return this.getConfig().getBoolean("bait.add-to-lore", (Boolean)true);
    }

    public double getBaitCatchPercentage() {
        return this.getConfig().getDouble("bait.catch-percentage", (Double)2.5);
    }

    public int getBaitsPerRod() {
        return this.getConfig().getInt("bait.baits-per-rod", (Integer)7);
    }

    public boolean getBaitShowUnusedSlots() {
        return this.getConfig().getBoolean("bait.show-unused-slots", (Boolean)true);
    }
}

