/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.annotations.NeedsTesting;
import com.oheers.fish.api.annotations.TestType;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionEntry;
import com.oheers.fish.competition.leaderboard.Leaderboard;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.DatabaseAPI;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.database.connection.H2ConnectionFactory;
import com.oheers.fish.database.connection.MigrationManager;
import com.oheers.fish.database.connection.MySqlConnectionFactory;
import com.oheers.fish.database.connection.SqliteConnectionFactory;
import com.oheers.fish.database.data.FishRarityKey;
import com.oheers.fish.database.execute.ExecuteQuery;
import com.oheers.fish.database.execute.ExecuteUpdate;
import com.oheers.fish.database.generated.mysql.Tables;
import com.oheers.fish.database.generated.mysql.tables.records.CompetitionsRecord;
import com.oheers.fish.database.generated.mysql.tables.records.FishLogRecord;
import com.oheers.fish.database.generated.mysql.tables.records.UserFishStatsRecord;
import com.oheers.fish.database.model.CompetitionReport;
import com.oheers.fish.database.model.fish.FishLog;
import com.oheers.fish.database.model.fish.FishStats;
import com.oheers.fish.database.model.user.UserFishStats;
import com.oheers.fish.database.model.user.UserReport;
import com.oheers.fish.database.strategies.DatabaseStrategyFactory;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.InsertSetMoreStep;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Result;
import com.oheers.fish.libs.jooq.SelectFieldOrAsterisk;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.conf.MappedSchema;
import com.oheers.fish.libs.jooq.conf.MappedTable;
import com.oheers.fish.libs.jooq.conf.RenderMapping;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.impl.DSL;
import java.sql.Connection;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NeedsTesting(reason="Requires full testing, unit where possible, integration eventually.", testType={TestType.MANUAL, TestType.UNIT, TestType.INTEGRATION})
public class Database
implements DatabaseAPI {
    private String version;
    private final ConnectionFactory connectionFactory;
    private final MigrationManager migrationManager;
    private Settings settings;

    public Database() {
        this.setJooqStartupProperties();
        this.settings = new Settings();
        this.connectionFactory = this.getConnectionFactory(MainConfig.getInstance().getDatabaseType().toLowerCase());
        this.connectionFactory.init();
        this.migrationManager = new MigrationManager(this.connectionFactory);
        if (this.migrationManager.usingV2()) {
            this.version = "2";
            return;
        }
        this.version = this.migrationManager.getDatabaseVersion().getVersion();
        this.migrateFromDatabaseVersionToLatest();
        this.initSettings(MainConfig.getInstance().getPrefix(), MainConfig.getInstance().getDatabase());
    }

    private void setJooqStartupProperties() {
        if (MainConfig.getInstance().isDisableJooqStartupCommments()) {
            System.setProperty("com.oheers.fish.libs.jooq.no-logo", "true");
            System.setProperty("com.oheers.fish.libs.jooq.no-tips", "true");
        }
    }

    public void migrateFromDatabaseVersionToLatest() {
        switch (this.version) {
            case "5": {
                this.migrationManager.migrateFromV5ToLatest();
                break;
            }
            case "6.0": {
                this.migrationManager.migrateFromV6ToLatest();
                break;
            }
            default: {
                this.migrationManager.migrateFromVersion(this.version, true);
            }
        }
        this.version = this.migrationManager.getDatabaseVersion().getVersion();
    }

    public MigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    @NotNull
    private ConnectionFactory getConnectionFactory(@NotNull String type) {
        return switch (type) {
            case "mysql" -> new MySqlConnectionFactory();
            case "sqlite" -> new SqliteConnectionFactory();
            default -> new H2ConnectionFactory();
        };
    }

    public void initSettings(String tablePrefix, String dbName) {
        this.settings.setExecuteLogging(true);
        this.settings.withRenderFormatted(true);
        this.settings.withRenderMapping(new RenderMapping().withSchemata(new MappedSchema().withInput("").withOutput(dbName).withTables(new MappedTable().withInputExpression(Pattern.compile("\\$\\{table\\.prefix}(.*)")).withOutput(tablePrefix + "$1"))));
        this.settings = DatabaseStrategyFactory.getStrategy(this.connectionFactory).applySettings(this.settings, tablePrefix, dbName);
    }

    @NotNull
    public DSLContext getContext(Connection connection) {
        return DSL.using(connection, DatabaseUtil.getSQLDialect(this.connectionFactory.getType()), this.settings);
    }

    @Override
    public boolean hasUser(final @NotNull UUID uuid) {
        return (Boolean)new ExecuteQuery<Boolean>(this, this.connectionFactory, this.settings){

            @Override
            protected Boolean onRunQuery(DSLContext dslContext) throws Exception {
                return dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.USERS).where(Tables.USERS.UUID.eq(uuid.toString())).fetch().isNotEmpty();
            }

            @Override
            protected Boolean empty() {
                return false;
            }
        }.prepareAndRunQuery();
    }

    public boolean hasFishLog(final int userId) {
        if (userId == 0) {
            return false;
        }
        return (Boolean)new ExecuteQuery<Boolean>(this, this.connectionFactory, this.settings){

            @Override
            protected Boolean onRunQuery(DSLContext dslContext) throws Exception {
                return dslContext.fetchExists(Tables.FISH_LOG.where(Tables.FISH_LOG.USER_ID.eq(userId)));
            }

            @Override
            protected Boolean empty() {
                return false;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public int getUserId(final @NotNull UUID uuid) {
        return (Integer)new ExecuteQuery<Integer>(this, this.connectionFactory, this.settings){

            @Override
            protected Integer onRunQuery(DSLContext dslContext) {
                Integer id = (Integer)dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.USERS).where(Tables.USERS.UUID.eq(uuid.toString())).fetchOne(Tables.USERS.ID);
                if (id == null) {
                    return this.empty();
                }
                return id;
            }

            @Override
            protected Integer empty() {
                return 0;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public UserReport getUserReport(final @NotNull UUID uuid) {
        return (UserReport)new ExecuteQuery<UserReport>(this, this.connectionFactory, this.settings){

            @Override
            protected UserReport onRunQuery(DSLContext dslContext) throws Exception {
                Object tableRecord = dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.USERS).where(Tables.USERS.UUID.eq(uuid.toString())).fetchOne();
                if (tableRecord == null) {
                    return this.empty();
                }
                DatabaseUtil.writeDbVerbose("Read user report for user (%s)".formatted(uuid.toString()));
                int id = (Integer)tableRecord.getValue(Tables.USERS.ID);
                int numFishCaught = (Integer)tableRecord.getValue(Tables.USERS.NUM_FISH_CAUGHT);
                int competitionsWon = (Integer)tableRecord.getValue(Tables.USERS.COMPETITIONS_WON);
                int competitionsJoined = (Integer)tableRecord.getValue(Tables.USERS.COMPETITIONS_JOINED);
                FishRarityKey firstFish = FishRarityKey.from((String)tableRecord.getValue(Tables.USERS.FIRST_FISH));
                FishRarityKey recentFish = FishRarityKey.from((String)tableRecord.getValue(Tables.USERS.LAST_FISH));
                FishRarityKey largestFish = FishRarityKey.from((String)tableRecord.getValue(Tables.USERS.LARGEST_FISH));
                float totalFishLength = ((Float)tableRecord.getValue(Tables.USERS.TOTAL_FISH_LENGTH)).floatValue();
                float largestLength = ((Float)tableRecord.getValue(Tables.USERS.LARGEST_LENGTH)).floatValue();
                String uuid2 = (String)tableRecord.getValue(Tables.USERS.UUID);
                int fishSold = (Integer)tableRecord.getValue(Tables.USERS.FISH_SOLD);
                double moneyEarned = (Double)tableRecord.getValue(Tables.USERS.MONEY_EARNED);
                FishRarityKey shortestFish = FishRarityKey.from((String)tableRecord.getValue(Tables.USERS.SHORTEST_FISH));
                float shortestLength = ((Float)tableRecord.getValue(Tables.USERS.SHORTEST_LENGTH)).floatValue();
                return new UserReport(id, UUID.fromString(uuid2), firstFish, recentFish, largestFish, shortestFish, numFishCaught, competitionsWon, competitionsJoined, largestLength, shortestLength, totalFishLength, fishSold, moneyEarned);
            }

            @Override
            @Nullable
            protected UserReport empty() {
                DatabaseUtil.writeDbVerbose("User report for (%s) does not exist in the database.".formatted(uuid));
                return null;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public boolean hasFishStats(final @NotNull Fish fish) {
        return (Boolean)new ExecuteQuery<Boolean>(this, this.connectionFactory, this.settings){

            @Override
            protected Boolean onRunQuery(DSLContext dslContext) throws Exception {
                return dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.FISH).where(Tables.FISH.FISH_NAME.eq(fish.getName()).and(Tables.FISH.FISH_RARITY.eq(fish.getRarity().getId()))).limit(1).fetch().isNotEmpty();
            }

            @Override
            protected Boolean empty() {
                return false;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public void incrementFish(final @NotNull Fish fish) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.update(Tables.FISH).set(Tables.FISH.TOTAL_CAUGHT, Tables.FISH.TOTAL_CAUGHT.plus(1)).where(Tables.FISH.FISH_RARITY.eq(fish.getRarity().getId()).and(Tables.FISH.FISH_NAME.eq(fish.getName()))).execute();
            }
        }.executeUpdate();
    }

    @Override
    public boolean userHasFish(@NotNull Fish fish, @NotNull HumanEntity user) {
        return this.userHasFish(fish.getRarity().getId(), fish.getName(), this.getUserId(user.getUniqueId()));
    }

    @Override
    public boolean userHasRarity(@NotNull Rarity rarity, @NotNull HumanEntity user) {
        return this.userHasRarity(rarity.getId(), this.getUserId(user.getUniqueId()));
    }

    @Override
    public void createCompetitionReport(final @NotNull Competition competition) {
        new ExecuteUpdate(this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                Leaderboard leaderboard = competition.getLeaderboard();
                InsertSetMoreStep<CompetitionsRecord> common = dslContext.insertInto(Tables.COMPETITIONS).set(Tables.COMPETITIONS.COMPETITION_NAME, competition.getCompetitionName());
                if (leaderboard.getSize() <= 0) {
                    return common.set(Tables.COMPETITIONS.WINNER_UUID, leaderboard.getTopEntry().getPlayer().toString()).set(Tables.COMPETITIONS.WINNER_FISH, Database.this.prepareRarityFishString(leaderboard.getEntry(0).getFish())).set(Tables.COMPETITIONS.WINNER_SCORE, Float.valueOf(leaderboard.getTopEntry().getValue())).set(Tables.COMPETITIONS.CONTESTANTS, Database.this.prepareContestantsString(leaderboard.getEntries())).execute();
                }
                return common.set(Tables.COMPETITIONS.WINNER_UUID, "None").set(Tables.COMPETITIONS.WINNER_FISH, "None").set(Tables.COMPETITIONS.WINNER_SCORE, Float.valueOf(0.0f)).set(Tables.COMPETITIONS.CONTESTANTS, "None").execute();
            }
        }.executeUpdate();
    }

    private String prepareContestantsString(@NotNull List<CompetitionEntry> entries) {
        return StringUtils.join(entries.stream().map(CompetitionEntry::getPlayer).toList(), (String)",");
    }

    @NotNull
    private String prepareRarityFishString(@NotNull Fish fish) {
        return fish.getRarity().getId() + ":" + fish.getName();
    }

    @Override
    public void createSale(final @NotNull String transactionId, final @NotNull String fishName, final @NotNull String fishRarity, final int fishAmount, final double fishLength, final double priceSold) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.USERS_SALES).set(Tables.USERS_SALES.TRANSACTION_ID, transactionId).set(Tables.USERS_SALES.FISH_NAME, fishName).set(Tables.USERS_SALES.FISH_RARITY, fishRarity).set(Tables.USERS_SALES.FISH_AMOUNT, fishAmount).set(Tables.USERS_SALES.FISH_LENGTH, fishLength).set(Tables.USERS_SALES.PRICE_SOLD, priceSold).execute();
            }
        }.executeUpdate();
    }

    @Override
    public void createTransaction(final @NotNull String transactionId, final int userId, final @NotNull Timestamp timestamp) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.TRANSACTIONS).set(Tables.TRANSACTIONS.ID, transactionId).set(Tables.TRANSACTIONS.USER_ID, userId).set(Tables.TRANSACTIONS.TIMESTAMP, timestamp.toLocalDateTime()).execute();
            }
        }.executeUpdate();
    }

    @Override
    public FishLog getFishLog(final int userId, final String fishName, final String fishRarity, final LocalDateTime time) {
        return (FishLog)new ExecuteQuery<FishLog>(this, this.connectionFactory, this.settings){

            @Override
            protected FishLog onRunQuery(DSLContext dslContext) throws Exception {
                Object result = dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.FISH_LOG).where(Tables.FISH_LOG.USER_ID.eq(userId).and(Tables.FISH_LOG.FISH_NAME.eq(fishName)).and(Tables.FISH_LOG.FISH_RARITY.eq(fishName)).and(Tables.FISH_LOG.CATCH_TIME.eq(time))).fetchOne();
                if (result == null) {
                    return this.empty();
                }
                float length = ((Float)result.getValue(Tables.FISH_LOG.FISH_LENGTH)).floatValue();
                String competitionId = (String)result.getValue(Tables.FISH_LOG.COMPETITION_ID);
                return new FishLog(userId, fishName, fishRarity, time, length, competitionId);
            }

            @Override
            protected FishLog empty() {
                return null;
            }
        }.prepareAndRunQuery();
    }

    public void shutdown() {
        try {
            this.connectionFactory.shutdown();
        }
        catch (Exception e) {
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String getDatabaseVersion() {
        if (!MainConfig.getInstance().databaseEnabled()) {
            return "Disabled";
        }
        if (!DatabaseUtil.isDatabaseOnline()) {
            return "Offline";
        }
        return "V" + this.version;
    }

    public String getType() {
        if (!MainConfig.getInstance().databaseEnabled()) {
            return "Disabled";
        }
        if (!DatabaseUtil.isDatabaseOnline()) {
            return "Offline";
        }
        return this.connectionFactory.getType();
    }

    @Override
    public UserFishStats getUserFishStats(final int userId, final String fishName, final String fishRarity) {
        return (UserFishStats)new ExecuteQuery<UserFishStats>(this, this.connectionFactory, this.settings){

            @Override
            protected UserFishStats onRunQuery(DSLContext dslContext) throws Exception {
                Optional optionalRecord = dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.USER_FISH_STATS).where(Tables.USER_FISH_STATS.USER_ID.eq(userId).and(Tables.USER_FISH_STATS.FISH_NAME.eq(fishName))).and(Tables.USER_FISH_STATS.FISH_RARITY.eq(fishRarity)).fetchOptional();
                if (optionalRecord.isEmpty()) {
                    return this.empty();
                }
                LocalDateTime firstCatchTime = (LocalDateTime)((Record)optionalRecord.get()).getValue(Tables.USER_FISH_STATS.FIRST_CATCH_TIME);
                float shortestLength = ((Float)((Record)optionalRecord.get()).getValue(Tables.USER_FISH_STATS.SHORTEST_LENGTH)).floatValue();
                float longestLength = ((Float)((Record)optionalRecord.get()).getValue(Tables.USER_FISH_STATS.LONGEST_LENGTH)).floatValue();
                int quantity = (Integer)((Record)optionalRecord.get()).getValue(Tables.USER_FISH_STATS.QUANTITY);
                return new UserFishStats(userId, fishName, fishRarity, firstCatchTime, shortestLength, longestLength, quantity);
            }

            @Override
            protected UserFishStats empty() {
                return null;
            }
        }.prepareAndRunQuery();
    }

    public void upsertUserFishStats(final UserFishStats userFishStats) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.USER_FISH_STATS).set(Tables.USER_FISH_STATS.USER_ID, userFishStats.getUserId()).set(Tables.USER_FISH_STATS.FISH_NAME, userFishStats.getFishName()).set(Tables.USER_FISH_STATS.FISH_RARITY, userFishStats.getFishRarity()).set(Tables.USER_FISH_STATS.FIRST_CATCH_TIME, userFishStats.getFirstCatchTime()).set(Tables.USER_FISH_STATS.SHORTEST_LENGTH, Float.valueOf(userFishStats.getShortestLength())).set(Tables.USER_FISH_STATS.LONGEST_LENGTH, Float.valueOf(userFishStats.getLongestLength())).set(Tables.USER_FISH_STATS.QUANTITY, userFishStats.getQuantity()).onDuplicateKeyUpdate().set(Tables.USER_FISH_STATS.SHORTEST_LENGTH, Float.valueOf(userFishStats.getShortestLength())).set(Tables.USER_FISH_STATS.LONGEST_LENGTH, Float.valueOf(userFishStats.getLongestLength())).set(Tables.USER_FISH_STATS.QUANTITY, userFishStats.getQuantity()).execute();
            }
        }.executeUpdate();
    }

    @Override
    public Set<FishLog> getFishLogEntries(final int userId, final String fishName, final String fishRarity) {
        return (Set)new ExecuteQuery<Set<FishLog>>(this, this.connectionFactory, this.settings){

            @Override
            protected Set<FishLog> onRunQuery(DSLContext dslContext) throws Exception {
                Result result = dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.FISH_LOG).where(Tables.FISH_LOG.USER_ID.eq(userId)).and(Tables.FISH_LOG.FISH_NAME.eq(fishName)).and(Tables.FISH_LOG.FISH_RARITY.eq(fishName)).fetch();
                if (result.isEmpty()) {
                    return this.empty();
                }
                HashSet<FishLog> fishLogs = new HashSet<FishLog>();
                for (Record recordResult : result) {
                    LocalDateTime catchTime = (LocalDateTime)recordResult.getValue(Tables.FISH_LOG.CATCH_TIME);
                    float length = ((Float)recordResult.getValue(Tables.FISH_LOG.FISH_LENGTH)).floatValue();
                    String competitionId = (String)recordResult.getValue(Tables.FISH_LOG.COMPETITION_ID);
                    fishLogs.add(new FishLog(userId, fishName, fishRarity, catchTime, length, competitionId));
                }
                return fishLogs;
            }

            @Override
            protected Set<FishLog> empty() {
                return Set.of();
            }
        }.prepareAndRunQuery();
    }

    @Override
    public void setFishLogEntry(final FishLog fishLogEntry) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.FISH_LOG).set(Tables.FISH_LOG.USER_ID, fishLogEntry.getUserId()).set(Tables.FISH_LOG.FISH_NAME, fishLogEntry.getFishName()).set(Tables.FISH_LOG.FISH_RARITY, fishLogEntry.getFishRarity()).set(Tables.FISH_LOG.FISH_LENGTH, Float.valueOf(fishLogEntry.getLength())).set(Tables.FISH_LOG.CATCH_TIME, fishLogEntry.getCatchTime()).set(Tables.FISH_LOG.COMPETITION_ID, fishLogEntry.getCompetitionId()).execute();
            }
        }.executeUpdate();
    }

    @Override
    public FishStats getFishStats(final String fishName, final String fishRarity) {
        return (FishStats)new ExecuteQuery<FishStats>(this, this.connectionFactory, this.settings){

            @Override
            protected FishStats onRunQuery(DSLContext dslContext) throws Exception {
                Optional optionalRecord = dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)Tables.FISH).where(Tables.FISH.FISH_NAME.eq(fishName)).and(Tables.FISH.FISH_RARITY.eq(fishRarity)).fetchOptional();
                if (optionalRecord.isEmpty()) {
                    return this.empty();
                }
                LocalDateTime firstCatchTime = (LocalDateTime)((Record)optionalRecord.get()).getValue(Tables.FISH.FIRST_CATCH_TIME);
                UUID discoverer = UUID.fromString((String)((Record)optionalRecord.get()).get(Tables.FISH.DISCOVERER));
                float shortestLength = ((Float)((Record)optionalRecord.get()).getValue(Tables.FISH.SHORTEST_LENGTH)).floatValue();
                UUID shortestFisher = UUID.fromString((String)((Record)optionalRecord.get()).getValue(Tables.FISH.SHORTEST_FISHER));
                float longestLength = ((Float)((Record)optionalRecord.get()).getValue(Tables.FISH.LARGEST_FISH)).floatValue();
                UUID longestFisher = UUID.fromString((String)((Record)optionalRecord.get()).getValue(Tables.FISH.LARGEST_FISHER));
                int quantity = (Integer)((Record)optionalRecord.get()).getValue(Tables.FISH.TOTAL_CAUGHT);
                return new FishStats(fishName, fishRarity, firstCatchTime, discoverer, shortestLength, shortestFisher, longestLength, longestFisher, quantity);
            }

            @Override
            protected FishStats empty() {
                return null;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public void upsertFishStats(final @NotNull FishStats fishStats) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.FISH).set(Tables.FISH.FISH_NAME, fishStats.getFishName()).set(Tables.FISH.FISH_RARITY, fishStats.getFishRarity()).set(Tables.FISH.FIRST_FISHER, fishStats.getDiscoverer().toString()).set(Tables.FISH.DISCOVERER, fishStats.getDiscoverer().toString()).set(Tables.FISH.TOTAL_CAUGHT, fishStats.getQuantity()).set(Tables.FISH.LARGEST_FISH, Float.valueOf(fishStats.getLongestLength())).set(Tables.FISH.LARGEST_FISHER, fishStats.getLongestFisher().toString()).set(Tables.FISH.SHORTEST_LENGTH, Float.valueOf(fishStats.getShortestLength())).set(Tables.FISH.SHORTEST_FISHER, fishStats.getShortestFisher().toString()).set(Tables.FISH.FIRST_CATCH_TIME, fishStats.getFirstCatchTime()).onDuplicateKeyUpdate().set(Tables.FISH.TOTAL_CAUGHT, fishStats.getQuantity()).set(Tables.FISH.LARGEST_FISH, DSL.when(Tables.FISH.LARGEST_FISH.lt(Float.valueOf(fishStats.getLongestLength())), Float.valueOf(fishStats.getLongestLength())).otherwise(Tables.FISH.LARGEST_FISH)).set(Tables.FISH.LARGEST_FISHER, DSL.when(Tables.FISH.LARGEST_FISH.lt(Float.valueOf(fishStats.getLongestLength())), fishStats.getLongestFisher().toString()).otherwise(Tables.FISH.LARGEST_FISHER)).set(Tables.FISH.SHORTEST_LENGTH, DSL.when(Tables.FISH.SHORTEST_LENGTH.gt(Float.valueOf(fishStats.getShortestLength())).or(Tables.FISH.SHORTEST_LENGTH.isNull()), Float.valueOf(fishStats.getShortestLength())).otherwise(Tables.FISH.SHORTEST_LENGTH)).set(Tables.FISH.SHORTEST_FISHER, DSL.when(Tables.FISH.SHORTEST_LENGTH.gt(Float.valueOf(fishStats.getShortestLength())).or(Tables.FISH.SHORTEST_LENGTH.isNull()), fishStats.getShortestFisher().toString()).otherwise(Tables.FISH.SHORTEST_FISHER)).execute();
            }
        }.executeInTransaction();
    }

    @Override
    public boolean userHasFish(final @NotNull String rarity, final @NotNull String fish, final int id) {
        return (Boolean)new ExecuteQuery<Boolean>(this, this.connectionFactory, this.settings){

            @Override
            protected Boolean onRunQuery(DSLContext dslContext) throws Exception {
                return dslContext.fetchExists((Table<?>)Tables.USER_FISH_STATS, Tables.USER_FISH_STATS.USER_ID.eq(id).and(Tables.USER_FISH_STATS.FISH_RARITY.eq(rarity)).and(Tables.USER_FISH_STATS.FISH_NAME.eq(fish)));
            }

            @Override
            protected Boolean empty() {
                return false;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public boolean userHasRarity(final @NotNull String rarity, final int id) {
        return (Boolean)new ExecuteQuery<Boolean>(this, this.connectionFactory, this.settings){

            @Override
            protected Boolean onRunQuery(DSLContext dslContext) throws Exception {
                return dslContext.fetchExists((Table<?>)Tables.USER_FISH_STATS, Tables.USER_FISH_STATS.USER_ID.eq(id).and(Tables.USER_FISH_STATS.FISH_RARITY.eq(rarity)));
            }

            @Override
            protected Boolean empty() {
                return false;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public void batchInsertFishLogs(final Collection<FishLog> logs) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                List<FishLogRecord> records = logs.stream().filter(Objects::nonNull).map(log -> {
                    FishLogRecord logRecord = new FishLogRecord();
                    logRecord.setUserId(log.getUserId());
                    logRecord.setFishLength(Float.valueOf(log.getLength()));
                    logRecord.setCompetitionId(log.getCompetitionId());
                    logRecord.setCatchTime(log.getCatchTime());
                    logRecord.setFishName(log.getFishName());
                    logRecord.setFishRarity(log.getFishRarity());
                    return logRecord;
                }).toList();
                if (records.isEmpty()) {
                    return 0;
                }
                dslContext.batchStore(records).execute();
                return records.size();
            }
        }.executeUpdate();
    }

    @Override
    public Integer upsertUserReport(final UserReport report) {
        return new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.USERS).set(Tables.USERS.UUID, report.getUuid().toString()).set(Tables.USERS.COMPETITIONS_JOINED, report.getCompetitionsJoined()).set(Tables.USERS.COMPETITIONS_WON, report.getCompetitionsWon()).set(Tables.USERS.TOTAL_FISH_LENGTH, Float.valueOf(report.getTotalFishLength())).set(Tables.USERS.FIRST_FISH, report.getFirstFish().toString()).set(Tables.USERS.MONEY_EARNED, report.getMoneyEarned()).set(Tables.USERS.FISH_SOLD, report.getFishSold()).set(Tables.USERS.NUM_FISH_CAUGHT, report.getNumFishCaught()).set(Tables.USERS.LARGEST_FISH, report.getLargestFish().toString()).set(Tables.USERS.LARGEST_LENGTH, Float.valueOf(report.getLargestLength())).set(Tables.USERS.LAST_FISH, report.getLargestFish().toString()).set(Tables.USERS.SHORTEST_FISH, report.getShortestFish().toString()).set(Tables.USERS.SHORTEST_LENGTH, Float.valueOf(report.getShortestLength())).onDuplicateKeyUpdate().set(Tables.USERS.COMPETITIONS_JOINED, report.getCompetitionsJoined()).set(Tables.USERS.COMPETITIONS_WON, report.getCompetitionsWon()).set(Tables.USERS.TOTAL_FISH_LENGTH, Float.valueOf(report.getTotalFishLength())).set(Tables.USERS.FIRST_FISH, report.getFirstFish().toString()).set(Tables.USERS.MONEY_EARNED, report.getMoneyEarned()).set(Tables.USERS.FISH_SOLD, report.getFishSold()).set(Tables.USERS.NUM_FISH_CAUGHT, report.getNumFishCaught()).set(Tables.USERS.LARGEST_FISH, report.getLargestFish().toString()).set(Tables.USERS.LARGEST_LENGTH, Float.valueOf(report.getLargestLength())).set(Tables.USERS.LAST_FISH, report.getLargestFish().toString()).set(Tables.USERS.SHORTEST_FISH, report.getShortestFish().toString()).set(Tables.USERS.SHORTEST_LENGTH, Float.valueOf(report.getShortestLength())).execute();
            }
        }.executeUpdate();
    }

    @Override
    public void batchUpdateUserFishStats(final Collection<UserFishStats> userFishStats) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                List<UserFishStatsRecord> records = userFishStats.stream().map(stats -> {
                    UserFishStatsRecord userFishStatsRecord = new UserFishStatsRecord();
                    userFishStatsRecord.setUserId(stats.getUserId());
                    userFishStatsRecord.setFishName(stats.getFishName());
                    userFishStatsRecord.setFishRarity(stats.getFishRarity());
                    userFishStatsRecord.setFirstCatchTime(stats.getFirstCatchTime());
                    userFishStatsRecord.setLongestLength(Float.valueOf(stats.getLongestLength()));
                    userFishStatsRecord.setShortestLength(Float.valueOf(stats.getShortestLength()));
                    userFishStatsRecord.setQuantity(stats.getQuantity());
                    return userFishStatsRecord;
                }).toList();
                dslContext.batchStore(records).execute();
                return records.size();
            }
        }.executeUpdate();
    }

    @Override
    public void updateCompetition(final CompetitionReport competition) {
        final String winnerUuid = competition.getWinnerUuid() == null ? "None" : competition.getWinnerUuid().toString();
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.COMPETITIONS).set(Tables.COMPETITIONS.COMPETITION_NAME, competition.getCompetitionConfigId()).set(Tables.COMPETITIONS.WINNER_FISH, competition.getWinnerFish()).set(Tables.COMPETITIONS.WINNER_UUID, winnerUuid).set(Tables.COMPETITIONS.WINNER_SCORE, Float.valueOf(competition.getWinnerScore())).set(Tables.COMPETITIONS.CONTESTANTS, competition.getContestants().stream().map(UUID::toString).collect(Collectors.joining(", "))).set(Tables.COMPETITIONS.START_TIME, competition.getStartTime()).set(Tables.COMPETITIONS.END_TIME, competition.getEndTime()).execute();
            }
        }.executeUpdate();
    }

    @Override
    public CompetitionReport getCompetitionReport(final int id) {
        return (CompetitionReport)new ExecuteQuery<CompetitionReport>(this, this.connectionFactory, this.settings){

            @Override
            protected CompetitionReport onRunQuery(DSLContext dslContext) throws Exception {
                Object result = dslContext.select(Tables.COMPETITIONS).where(Tables.COMPETITIONS.ID.eq(id)).fetchOne();
                if (result == null) {
                    return this.empty();
                }
                return new CompetitionReport((String)result.getValue(Tables.COMPETITIONS.COMPETITION_NAME), (String)result.getValue(Tables.COMPETITIONS.WINNER_FISH), (String)result.getValue(Tables.COMPETITIONS.WINNER_UUID), ((Float)result.getValue(Tables.COMPETITIONS.WINNER_SCORE)).floatValue(), (String)result.getValue(Tables.COMPETITIONS.CONTESTANTS), (LocalDateTime)result.getValue(Tables.COMPETITIONS.START_TIME), (LocalDateTime)result.getValue(Tables.COMPETITIONS.END_TIME));
            }

            @Override
            protected CompetitionReport empty() {
                return null;
            }
        }.prepareAndRunQuery();
    }

    @Override
    public void batchUpdateCompetitions(final Collection<CompetitionReport> competitions) {
        new ExecuteUpdate(this, this.connectionFactory, this.settings){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                List<CompetitionsRecord> records = competitions.stream().map(competition -> {
                    CompetitionsRecord competitionsRecord = new CompetitionsRecord();
                    competitionsRecord.setCompetitionName(competition.getCompetitionConfigId());
                    competitionsRecord.setWinnerFish(competition.getWinnerFish());
                    competitionsRecord.setWinnerUuid(competition.getWinnerUuid().toString());
                    competitionsRecord.setWinnerScore(Float.valueOf(competition.getWinnerScore()));
                    competitionsRecord.setContestants(competition.getContestants().stream().map(UUID::toString).collect(Collectors.joining(", ")));
                    competitionsRecord.setStartTime(competition.getStartTime());
                    competitionsRecord.setEndTime(competition.getEndTime());
                    return competitionsRecord;
                }).toList();
                dslContext.batchInsert(records).execute();
                return records.size();
            }
        }.executeUpdate();
    }
}

