/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.migrate;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.Database;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.database.connection.MigrationManager;
import com.oheers.fish.database.execute.ExecuteUpdate;
import com.oheers.fish.database.generated.mysql.Tables;
import com.oheers.fish.database.migrate.LegacyFishReport;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.PrefixType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class LegacyToV3DatabaseMigration {
    private final Database database;
    private final MigrationManager migrationManager;
    private final ConnectionFactory connectionFactory;

    public LegacyToV3DatabaseMigration(Database database, MigrationManager migrationManager, ConnectionFactory connectionFactory) {
        this.database = database;
        this.migrationManager = migrationManager;
        this.connectionFactory = connectionFactory;
    }

    private void translateFishDataV2() {
        if (this.migrationManager.queryTableExistence("${table.prefix}fish")) {
            return;
        }
        if (this.migrationManager.queryTableExistence("Fish2")) {
            this.executeStatement(c -> c.alterTable("Fish2").renameTo("${table.prefix}fish").execute());
            return;
        }
        this.migrationManager.legacyInitVersion();
    }

    private void translateFishReportsV2(UUID uuid, @NotNull List<LegacyFishReport> reports) {
        Object firstFishID = "";
        long epochFirst = Long.MAX_VALUE;
        Object largestFishID = "";
        float largestSize = 0.0f;
        int totalFish = 0;
        for (LegacyFishReport report : reports) {
            if (report.getTimeEpoch() < epochFirst) {
                epochFirst = report.getTimeEpoch();
                firstFishID = report.getRarity() + ":" + report.getName();
            }
            if (report.getLargestLength() > largestSize) {
                largestSize = report.getLargestLength();
                largestFishID = report.getRarity() + ":" + report.getName();
            }
            totalFish += report.getNumCaught();
            Table<Record> fishLog = DSL.table(MainConfig.getInstance().getPrefix() + "fish_log");
            Field<Integer> id = DSL.field("id", Integer.class);
            Field<String> rarity = DSL.field("rarity", String.class);
            Field<String> fish = DSL.field("fish", String.class);
            Field<Integer> quantity = DSL.field("quantity", Integer.class);
            Field<Long> fishCatchTime = DSL.field("first_catch_time", Long.class);
            Field<Float> largestLength = DSL.field("largest_length", Float.class);
            this.executeStatement(c -> c.insertInto(fishLog).set(id, this.database.getUserId(uuid)).set(rarity, report.getRarity()).set(fish, report.getName()).set(quantity, report.getNumCaught()).set(fishCatchTime, report.getTimeEpoch()).set(largestLength, Float.valueOf(report.getLargestLength())).execute());
        }
        this.createFieldForFishFirstTimeFished(uuid, (String)firstFishID, (String)largestFishID, totalFish, largestSize);
    }

    private void createFieldForFishFirstTimeFished(UUID uuid, String firstFishID, String largestFishID, int totalFish, float largestSize) {
        Table<Record> usersTable = DSL.table(MainConfig.getInstance().getPrefix() + "users");
        Field<String> firstFishField = DSL.field("first_fish", String.class);
        Field<String> largestFishField = DSL.field("largest_fish", String.class);
        Field<Integer> totalFishField = DSL.field("num_fish_caught", Integer.class);
        Field<Float> largestLengthField = DSL.field("largest_length", Float.class);
        Field<String> uuidField = DSL.field("uuid", String.class);
        this.executeStatement(c -> c.update(usersTable).set(firstFishField, firstFishID).set(largestFishField, largestFishID).set(totalFishField, totalFish).set(largestLengthField, Float.valueOf(largestSize)).where(uuidField.eq(uuid.toString())).execute());
    }

    public void migrate(CommandSender initiator) {
        if (!this.migrationManager.usingV2()) {
            EMFSingleMessage msg = EMFSingleMessage.fromString("EvenMoreFish is already using the latest V3 database engine.");
            msg.prependMessage(PrefixType.ERROR.getPrefix());
            msg.send((Audience)initiator);
            return;
        }
        EvenMoreFish.getInstance().getLogger().info(() -> initiator.getName() + " has begun the migration to EMF database V3 from V2.");
        EMFSingleMessage msg = EMFSingleMessage.fromString("Beginning conversion to V3 database engine.");
        msg.prependMessage(PrefixType.ADMIN.getPrefix());
        msg.send((Audience)initiator);
        File oldDataFolder = new File(EvenMoreFish.getInstance().getDataFolder(), "data");
        File dataFolder = new File(EvenMoreFish.getInstance().getDataFolder(), "data-archived");
        if (!oldDataFolder.renameTo(dataFolder)) {
            EMFSingleMessage message = EMFSingleMessage.fromString("Failed to archive /data/ folder. Cancelling migration. [No further information]");
            message.prependMessage(PrefixType.ADMIN.getPrefix());
            message.send((Audience)initiator);
            return;
        }
        EMFSingleMessage message = EMFSingleMessage.fromString("Archived /data/ folder.");
        message.prependMessage(PrefixType.ADMIN.getPrefix());
        message.send((Audience)initiator);
        EMFSingleMessage fishReportMSG = EMFSingleMessage.fromString("Beginning FishReport migrations. This may take a while.");
        fishReportMSG.prependMessage(PrefixType.ADMIN.getPrefix());
        fishReportMSG.send((Audience)initiator);
        try {
            this.translateFishDataV2();
            this.migrationManager.legacyFlywayBaseline();
            for (File file : Objects.requireNonNull(dataFolder.listFiles())) {
                List reports;
                Type fishReportList = new TypeToken<List<LegacyFishReport>>(){}.getType();
                Gson gson = new Gson();
                try (FileReader reader = new FileReader(file);){
                    reports = (List)gson.fromJson((Reader)reader, fishReportList);
                }
                UUID playerUUID = UUID.fromString(file.getName().substring(0, file.getName().lastIndexOf(".")));
                this.createEmptyUserReport(playerUUID);
                this.translateFishReportsV2(playerUUID, reports);
                EMFSingleMessage migratedMSG = EMFSingleMessage.fromString("Migrated " + reports.size() + " fish for: " + String.valueOf(playerUUID));
                migratedMSG.prependMessage(PrefixType.ADMIN.getPrefix());
                migratedMSG.send((Audience)initiator);
            }
        }
        catch (FileNotFoundException | NullPointerException exception) {
            EMFSingleMessage message2 = EMFSingleMessage.fromString("Fatal error whilst upgrading to V3 database engine.");
            message2.prependMessage(PrefixType.ERROR.getPrefix());
            message2.send((Audience)initiator);
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, "Critical SQL/interruption error whilst upgrading to v3 engine.", exception);
        }
        catch (IOException e) {
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        EMFSingleMessage migratedMSG = EMFSingleMessage.fromString("Migration completed. Your database is now using the V3 database engine: to complete the migration, it is recommended to restart your server.");
        migratedMSG.prependMessage(PrefixType.ADMIN.getPrefix());
        migratedMSG.send((Audience)initiator);
        EMFSingleMessage thankyou = EMFSingleMessage.fromString("Now that migration is complete, you will be able to use functionality in upcoming updates such as quests, deliveries and a fish log. - Oheers");
        thankyou.prependMessage(PrefixType.ERROR.getPrefix());
        thankyou.send((Audience)initiator);
        this.migrationManager.migrateFromV5ToLatest();
    }

    public void createEmptyUserReport(final @NotNull UUID uuid) {
        new ExecuteUpdate(this, this.connectionFactory, this.migrationManager.getMigrationSettings()){

            @Override
            protected int onRunUpdate(DSLContext dslContext) {
                return dslContext.insertInto(Tables.USERS).set(Tables.USERS.UUID, uuid.toString()).set(Tables.USERS.FIRST_FISH, "None").set(Tables.USERS.LAST_FISH, "None").set(Tables.USERS.LARGEST_FISH, "None").set(Tables.USERS.LARGEST_LENGTH, Float.valueOf(0.0f)).set(Tables.USERS.NUM_FISH_CAUGHT, 0).set(Tables.USERS.COMPETITIONS_WON, 0).set(Tables.USERS.COMPETITIONS_JOINED, 0).set(Tables.USERS.TOTAL_FISH_LENGTH, Float.valueOf(0.0f)).execute();
            }
        }.executeUpdate();
    }

    public void executeStatement(@NotNull Consumer<DSLContext> consumer) {
        try (Connection connection = this.connectionFactory.getConnection();){
            consumer.accept(this.database.getContext(connection));
        }
        catch (SQLException e) {
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

