/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing.rods;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.Logging;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.recipe.EMFRecipe;
import com.oheers.fish.recipe.RecipeUtil;
import com.oheers.fish.utils.nbt.NbtKeys;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.iface.ReadWriteNBT;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRod
extends ConfigBase {
    private final List<Rarity> allowedRarities;
    private final List<Fish> allowedFish;
    private final EMFRecipe<?> recipe;
    private final ItemFactory factory;

    public CustomRod(@NotNull File file) throws InvalidConfigurationException {
        super(file, (Plugin)EvenMoreFish.getInstance(), false);
        this.performRequiredConfigChecks();
        this.allowedRarities = this.loadAllowedRarities();
        this.allowedFish = this.loadAllowedFish();
        this.factory = ItemFactory.itemFactory(this.getConfig());
        this.factory.setFinalChanges(item -> NBT.modify(item, nbt -> {
            ReadWriteNBT emfCompound = nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND);
            emfCompound.setString("emf-rod-id", this.getId());
        }));
        this.recipe = this.loadRecipe();
    }

    private void performRequiredConfigChecks() throws InvalidConfigurationException {
        if (this.getConfig().getString("id") == null) {
            Logging.warn("Custom Rod invalid: 'id' missing in " + this.getFileName());
            throw new InvalidConfigurationException("An ID has not been found in " + this.getFileName() + ". Please correct this.");
        }
    }

    public List<Rarity> loadAllowedRarities() {
        if ("ALL".equalsIgnoreCase(this.getConfig().getString("allowed-rarities"))) {
            return FishManager.getInstance().getRarityMap().values().stream().toList();
        }
        return this.getConfig().getStringList("allowed-rarities").stream().map(id -> FishManager.getInstance().getRarity((String)id)).filter(Objects::nonNull).toList();
    }

    public List<Fish> loadAllowedFish() {
        Section section = this.getConfig().getSection("allowed-fish");
        if (section == null) {
            return List.of();
        }
        return section.getRoutesAsStrings(false).stream().flatMap(rarityId -> {
            Rarity rarity = FishManager.getInstance().getRarity((String)rarityId);
            if (rarity == null) {
                Logging.warn("Rarity '" + rarityId + "' not found for custom rod '" + this.getId() + "'.");
                return Stream.empty();
            }
            if (!this.allowedRarities.contains(rarity)) {
                Logging.warn("Rarity '" + rarityId + "' is not allowed for custom rod '" + this.getId() + "'.");
                return Stream.empty();
            }
            return section.getStringList((String)rarityId).stream().map(rarity::getFish).filter(Objects::nonNull);
        }).toList();
    }

    private EMFRecipe<?> loadRecipe() {
        Section section = this.getConfig().getSection("recipe");
        if (section == null) {
            return null;
        }
        return RecipeUtil.getRecipe(section, this.getRecipeKey(), this.create());
    }

    @NotNull
    public String getId() {
        return Objects.requireNonNull(this.getConfig().getString("id"));
    }

    @NotNull
    private NamespacedKey getRecipeKey() {
        return new NamespacedKey((Plugin)EvenMoreFish.getInstance(), "customrod-" + this.getId());
    }

    public boolean isDisabled() {
        return this.getConfig().getBoolean("disabled");
    }

    public ItemFactory getFactory() {
        return this.factory;
    }

    public ItemStack create() {
        return this.factory.createItem();
    }

    public List<Rarity> getAllowedRarities() {
        return this.allowedRarities;
    }

    public List<Fish> getAllowedFish() {
        return this.allowedFish;
    }

    @Nullable
    public EMFRecipe<?> getRecipe() {
        return this.recipe;
    }
}

