/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.gui.guis;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.Logging;
import com.oheers.fish.config.GuiConfig;
import com.oheers.fish.database.Database;
import com.oheers.fish.database.data.FishRarityKey;
import com.oheers.fish.database.data.UserFishRarityKey;
import com.oheers.fish.database.model.fish.FishStats;
import com.oheers.fish.database.model.user.UserFishStats;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.gui.ConfigGui;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.libs.inventorygui.DynamicGuiElement;
import com.oheers.fish.libs.inventorygui.GuiElement;
import com.oheers.fish.libs.inventorygui.GuiElementGroup;
import com.oheers.fish.libs.inventorygui.StaticGuiElement;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishJournalGui
extends ConfigGui {
    private final Rarity rarity;
    private final SortType sortType;

    public FishJournalGui(@NotNull HumanEntity player, @Nullable Rarity rarity) {
        super(GuiConfig.getInstance().getConfig().getSection(rarity == null ? "journal-menu" : "journal-rarity"), player);
        this.rarity = rarity;
        this.createGui();
        Section config = this.getGuiConfig();
        if (config != null) {
            this.getGui().addElement(this.getGroup(config));
            this.sortType = SortType.fromString(config.getString("sort-type"));
        } else {
            this.sortType = SortType.ALPHABETICAL;
        }
    }

    private DynamicGuiElement getGroup(Section section) {
        return this.rarity == null ? this.getRarityGroup(section) : this.getFishGroup(section);
    }

    private DynamicGuiElement getFishGroup(Section section) {
        char character = FishUtils.getCharFromString(section.getString("fish-character"), 'f');
        return new DynamicGuiElement(character, who -> {
            GuiElementGroup group = new GuiElementGroup(character, new GuiElement[0]);
            this.sortType.sortFish(this.rarity.getFishList()).forEach(fish -> {
                if (!fish.getShowInJournal()) {
                    return;
                }
                ItemStack item = this.getFishItem((Fish)fish, section);
                if (item.isEmpty()) {
                    return;
                }
                group.addElement(new StaticGuiElement(character, item, new String[0]));
            });
            return group;
        });
    }

    private ItemStack getFishItem(Fish fish, Section section) {
        Database database = this.requireDatabase("Can not show fish in the Journal Menu, please enable the database!");
        if (database == null) {
            return ItemFactory.itemFactory(section, "undiscovered-fish").createItem(this.player.getUniqueId());
        }
        boolean hideUndiscovered = section.getBoolean("hide-undiscovered-fish", (Boolean)true);
        if (hideUndiscovered && !database.userHasFish(fish, (HumanEntity)this.player)) {
            return ItemFactory.itemFactory(section, "undiscovered-fish").createItem(this.player.getUniqueId());
        }
        ItemStack item = fish.give();
        item.editMeta(meta -> {
            ItemFactory factory = ItemFactory.itemFactory(section, "fish-item");
            EMFSingleMessage display = this.prepareDisplay(factory, fish);
            if (display != null) {
                meta.displayName(display.getComponentMessage((OfflinePlayer)this.player));
            }
            meta.lore(this.prepareLore(factory, fish).getComponentListMessage((OfflinePlayer)this.player));
        });
        return item;
    }

    @Nullable
    private EMFSingleMessage prepareDisplay(@NotNull ItemFactory factory, @NotNull Fish fish) {
        String displayStr = factory.getDisplayName().getConfiguredValue();
        if (displayStr == null) {
            return null;
        }
        EMFSingleMessage display = EMFSingleMessage.fromString(displayStr);
        display.setVariable("{fishname}", fish.getDisplayName());
        return display;
    }

    @NotNull
    private EMFListMessage prepareLore(@NotNull ItemFactory factory, @NotNull Fish fish) {
        int userId = EvenMoreFish.getInstance().getPluginDataManager().getUserManager().getUserId(this.player.getUniqueId());
        UserFishStats userFishStats = EvenMoreFish.getInstance().getPluginDataManager().getUserFishStatsDataManager().get(UserFishRarityKey.of(userId, fish).toString());
        FishStats fishStats = EvenMoreFish.getInstance().getPluginDataManager().getFishStatsDataManager().get(FishRarityKey.of(fish).toString());
        String discoverDate = this.getValueOrUnknown(() -> userFishStats.getFirstCatchTime().format(DateTimeFormatter.ISO_DATE));
        String discoverer = this.getValueOrUnknown(() -> FishUtils.getPlayerName(fishStats.getDiscoverer()));
        EMFListMessage lore = EMFListMessage.fromStringList(Optional.ofNullable(factory.getLore().getConfiguredValue()).orElse(Collections.emptyList()));
        lore.setVariable("{times-caught}", this.getValueOrUnknown(() -> Integer.toString(userFishStats.getQuantity())));
        lore.setVariable("{largest-size}", this.getValueOrUnknown(() -> String.valueOf(userFishStats.getLongestLength())));
        lore.setVariable("{smallest-size}", this.getValueOrUnknown(() -> String.valueOf(userFishStats.getShortestLength())));
        lore.setVariable("{discover-date}", discoverDate);
        lore.setVariable("{discoverer}", discoverer);
        lore.setVariable("{server-largest}", this.getValueOrUnknown(() -> String.valueOf(fishStats.getLongestLength())));
        lore.setVariable("{server-smallest}", this.getValueOrUnknown(() -> String.valueOf(fishStats.getShortestLength())));
        lore.setVariable("{server-caught}", this.getValueOrUnknown(() -> String.valueOf(fishStats.getQuantity())));
        return lore;
    }

    @NotNull
    private String getValueOrUnknown(Supplier<String> supplier) {
        return Optional.ofNullable(supplier.get()).orElse("Unknown");
    }

    private DynamicGuiElement getRarityGroup(Section section) {
        char character = FishUtils.getCharFromString(section.getString("rarity-character"), 'r');
        return new DynamicGuiElement(character, who -> {
            GuiElementGroup group = new GuiElementGroup(character, new GuiElement[0]);
            this.sortType.sortRarities(FishManager.getInstance().getRarityMap().values()).forEach(rarity -> {
                if (!rarity.getShowInJournal()) {
                    return;
                }
                ItemStack item = this.getRarityItem((Rarity)rarity, section);
                if (item.isEmpty()) {
                    return;
                }
                group.addElement(new StaticGuiElement(character, item, click -> {
                    new FishJournalGui((HumanEntity)this.player, (Rarity)rarity).open();
                    return true;
                }, new String[0]));
            });
            return group;
        });
    }

    private ItemStack getRarityItem(Rarity rarity, Section section) {
        Database database = this.requireDatabase("Can not show rarities in the Journal Menu, please enable the database!");
        if (database == null) {
            return ItemFactory.itemFactory(section, "undiscovered-rarity").createItem(this.player.getUniqueId());
        }
        boolean hideUndiscovered = section.getBoolean("hide-undiscovered-rarity", (Boolean)true);
        if (hideUndiscovered && !database.userHasRarity(rarity, (HumanEntity)this.player)) {
            return ItemFactory.itemFactory(section, "undiscovered-rarity").createItem(this.player.getUniqueId());
        }
        ItemStack rarityItem = rarity.getMaterial();
        ItemStack configuredItem = ItemFactory.itemFactory(section, "rarity-item").createItem(this.player.getUniqueId());
        ItemMeta configuredMeta = configuredItem.getItemMeta();
        if (configuredMeta != null) {
            rarityItem.editMeta(meta -> {
                Component configuredDisplay = configuredMeta.displayName();
                if (configuredDisplay != null) {
                    EMFSingleMessage display = EMFSingleMessage.of(configuredDisplay);
                    display.setRarity(rarity.getDisplayName());
                    meta.displayName(display.getComponentMessage((OfflinePlayer)this.player));
                }
                meta.lore(configuredMeta.lore());
                if (configuredMeta.hasCustomModelData()) {
                    meta.setCustomModelData(Integer.valueOf(configuredMeta.getCustomModelData()));
                }
            });
        }
        return rarityItem;
    }

    @Override
    public void doRescue() {
    }

    @Nullable
    private Database requireDatabase(String logMessage) {
        Database db = EvenMoreFish.getInstance().getPluginDataManager().getDatabase();
        if (db == null) {
            Logging.warn(logMessage);
        }
        return db;
    }

    public static enum SortType {
        ALPHABETICAL(Comparator.comparing(Rarity::getId), Comparator.comparing(Fish::getName)),
        WEIGHT(Comparator.comparingDouble(Rarity::getWeight).reversed(), Comparator.comparingDouble(Fish::getWeight).reversed());

        private final Comparator<Rarity> rarityComparator;
        private final Comparator<Fish> fishComparator;

        private SortType(Comparator<Rarity> rarityComparator, Comparator<Fish> fishComparator) {
            this.rarityComparator = rarityComparator;
            this.fishComparator = fishComparator;
        }

        public TreeSet<Rarity> sortRarities(@NotNull Collection<Rarity> collection) {
            TreeSet<Rarity> set = new TreeSet<Rarity>(this.rarityComparator);
            set.addAll(collection);
            return set;
        }

        public TreeSet<Fish> sortFish(@NotNull Collection<Fish> collection) {
            TreeSet<Fish> set = new TreeSet<Fish>(this.fishComparator);
            set.addAll(collection);
            return set;
        }

        public static SortType fromString(@Nullable String string) {
            if (string == null) {
                return ALPHABETICAL;
            }
            try {
                return SortType.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                return ALPHABETICAL;
            }
        }
    }
}

