/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.gui.guis;

import com.oheers.fish.FishUtils;
import com.oheers.fish.api.economy.Economy;
import com.oheers.fish.config.GuiConfig;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.gui.ConfigGui;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.libs.inventorygui.GuiStorageElement;
import com.oheers.fish.selling.SellHelper;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SellGui
extends ConfigGui {
    private final Inventory fishInventory;

    public SellGui(@NotNull Player player, @NotNull SellState sellState, @Nullable Inventory fishInventory) {
        super(sellState.getGuiConfig(), (HumanEntity)player);
        this.fishInventory = Objects.requireNonNullElseGet(fishInventory, () -> Bukkit.createInventory((InventoryHolder)player, (int)54));
        Economy economy = Economy.getInstance();
        SellHelper shopHelper = new SellHelper(this.fishInventory, player);
        this.addReplacement("{sell-price}", economy.getWorthFormat(shopHelper.getTotalWorth(), true));
        SellHelper playerHelper = new SellHelper((Inventory)player.getInventory(), player);
        this.addReplacement("{sell-all-price}", economy.getWorthFormat(playerHelper.getTotalWorth(), true));
        this.setCloseAction(close -> {
            if (MainConfig.getInstance().sellOverDrop()) {
                new SellHelper(this.fishInventory, this.player).sellFish();
            }
            this.doRescue();
            return false;
        });
        this.createGui();
        Section config = this.getGuiConfig();
        if (config != null) {
            this.getGui().addElement(new GuiStorageElement(FishUtils.getCharFromString(this.getGuiConfig().getString("deposit-character", "i"), 'i'), this.fishInventory));
        }
    }

    public Inventory getFishInventory() {
        return this.fishInventory;
    }

    public static enum SellState {
        NORMAL("sell-menu-normal"),
        CONFIRM("sell-menu-confirm");

        private final String configLocation;

        private SellState(String configLocation) {
            this.configLocation = configLocation;
        }

        public Section getGuiConfig() {
            return GuiConfig.getInstance().getConfig().getSection(this.configLocation);
        }
    }
}

