/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.items.configs;

import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemConfig<T> {
    private T def;
    private T override;
    protected final Section section;
    protected boolean enabled = true;

    public ItemConfig(@NotNull Section section) {
        this.section = section;
    }

    public T getActualValue() {
        if (this.override != null) {
            return this.override;
        }
        T configured = this.getConfiguredValue();
        if (configured == null) {
            return this.def;
        }
        return configured;
    }

    public void apply(@NotNull ItemStack item, @Nullable Map<String, ?> replacements) {
        if (!this.enabled) {
            return;
        }
        T value = this.getActualValue();
        if (value != null) {
            this.applyToItem(replacements).accept(item, (ItemStack)value);
        }
    }

    public abstract T getConfiguredValue();

    protected abstract BiConsumer<ItemStack, T> applyToItem(@Nullable Map<String, ?> var1);

    public void setDefault(T def) {
        this.def = def;
    }

    public void setOverride(T override) {
        this.override = override;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

