/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.commandapi.wrappers;

import java.util.Objects;

public class DoubleRange {
    private final double low;
    private final double high;

    public DoubleRange(double low, double high) {
        this.low = low;
        this.high = high;
    }

    public static DoubleRange doubleRangeGreaterThanOrEq(double min) {
        return new DoubleRange(min, Double.MAX_VALUE);
    }

    public static DoubleRange doubleRangeLessThanOrEq(double max) {
        return new DoubleRange(-1.7976931348623157E308, max);
    }

    public double getLowerBound() {
        return this.low;
    }

    public double getUpperBound() {
        return this.high;
    }

    public boolean isInRange(double f) {
        return f >= this.low && f <= this.high;
    }

    public String toString() {
        if (this.high == Double.MAX_VALUE) {
            return this.low + "..";
        }
        if (this.low == -1.7976931348623157E308) {
            return ".." + this.high;
        }
        return this.low + ".." + this.high;
    }

    public int hashCode() {
        return Objects.hash(this.high, this.low);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleRange)) {
            return false;
        }
        DoubleRange other = (DoubleRange)obj;
        return Double.doubleToLongBits(this.high) == Double.doubleToLongBits(other.high) && Double.doubleToLongBits(this.low) == Double.doubleToLongBits(other.low);
    }
}

