/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.ExecuteContext;
import com.oheers.fish.libs.jooq.ExecuteListener;
import com.oheers.fish.libs.jooq.Query;
import com.oheers.fish.libs.jooq.conf.SettingsTools;
import com.oheers.fish.libs.jooq.exception.ControlFlowSignal;
import com.oheers.fish.libs.jooq.impl.AbstractBatch;
import com.oheers.fish.libs.jooq.impl.AbstractQuery;
import com.oheers.fish.libs.jooq.impl.DefaultExecuteContext;
import com.oheers.fish.libs.jooq.impl.DefaultRenderContext;
import com.oheers.fish.libs.jooq.impl.ExecuteListeners;
import com.oheers.fish.libs.jooq.impl.NoConnectionFactory;
import com.oheers.fish.libs.jooq.impl.R2DBC;
import com.oheers.fish.libs.jooq.impl.SettingsEnabledPreparedStatement;
import com.oheers.fish.libs.jooq.impl.Tools;
import io.r2dbc.spi.ConnectionFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;

final class BatchMultiple
extends AbstractBatch {
    final Query[] queries;

    public BatchMultiple(Configuration configuration, Query ... queries) {
        super(configuration);
        this.queries = queries;
    }

    @Override
    public final int size() {
        return this.queries.length;
    }

    @Override
    public final void subscribe(Subscriber<? super Integer> subscriber) {
        ConnectionFactory cf = this.configuration.connectionFactory();
        if (cf instanceof NoConnectionFactory) {
            throw new UnsupportedOperationException("The blocking, JDBC backed implementation of reactive batching has not yet been implemented. Use the R2DBC backed implementation, instead, or avoid batching.");
        }
        subscriber.onSubscribe(new R2DBC.BatchSubscription<BatchMultiple>(this, subscriber, s -> new R2DBC.BatchMultipleSubscriber(this, (R2DBC.BatchSubscription<BatchMultiple>)s)));
    }

    @Override
    public final int[] execute() {
        return Tools.chunks(Arrays.asList(this.queries), SettingsTools.getBatchSize(Tools.settings(this.configuration))).stream().map(chunk -> BatchMultiple.execute(Tools.configuration(this.configuration), chunk.toArray(Tools.EMPTY_QUERY))).flatMapToInt(IntStream::of).toArray();
    }

    static int[] execute(Configuration configuration, Query[] queries) {
        if (NO_SUPPORT_BATCH.contains((Object)configuration.dialect())) {
            return Stream.of(queries).mapToInt(configuration.dsl()::execute).toArray();
        }
        DefaultExecuteContext ctx = new DefaultExecuteContext(configuration, ExecuteContext.BatchMode.MULTIPLE, queries);
        ExecuteListener listener = ExecuteListeners.get(ctx, true);
        try {
            int i;
            int t;
            listener.start(ctx);
            ctx.transformQueries(listener);
            if (ctx.statement() == null) {
                ctx.statement(new SettingsEnabledPreparedStatement(AbstractQuery.connection(ctx)));
            }
            if ((t = SettingsTools.getQueryTimeout(0, ctx.settings())) != 0) {
                ctx.statement().setQueryTimeout(t);
            }
            String[] batchSQL = ctx.batchSQL();
            for (i = 0; i < ctx.batchQueries().length; ++i) {
                ctx.sql(null);
                listener.renderStart(ctx);
                DefaultRenderContext.Rendered r = DefaultRenderContext.Rendered.rendered(configuration, ctx, ctx.batchQueries()[i], false, true);
                r.setSQLAndParams(ctx);
                batchSQL[i] = r.sql;
                ctx.sql(batchSQL[i]);
                listener.renderEnd(ctx);
            }
            for (i = 0; i < ctx.batchQueries().length; ++i) {
                ctx.sql(batchSQL[i]);
                listener.prepareStart(ctx);
                ctx.statement().addBatch(batchSQL[i]);
                listener.prepareEnd(ctx);
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i2 = 0; i2 < batchRows.length && i2 < result.length; ++i2) {
                batchRows[i2] = result[i2];
            }
            listener.executeEnd(ctx);
            int[] nArray = result;
            return nArray;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }

    public String toString() {
        return this.dsl.queries(this.queries).toString();
    }
}

