/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Batch;
import com.oheers.fish.libs.jooq.BatchBindStep;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.ExecuteContext;
import com.oheers.fish.libs.jooq.ExecuteListener;
import com.oheers.fish.libs.jooq.Param;
import com.oheers.fish.libs.jooq.Query;
import com.oheers.fish.libs.jooq.RowCountQuery;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.conf.SettingsTools;
import com.oheers.fish.libs.jooq.exception.ControlFlowSignal;
import com.oheers.fish.libs.jooq.impl.AbstractBatch;
import com.oheers.fish.libs.jooq.impl.AbstractQuery;
import com.oheers.fish.libs.jooq.impl.BatchMultiple;
import com.oheers.fish.libs.jooq.impl.DefaultBindContext;
import com.oheers.fish.libs.jooq.impl.DefaultExecuteContext;
import com.oheers.fish.libs.jooq.impl.DefaultRenderContext;
import com.oheers.fish.libs.jooq.impl.ExecuteListeners;
import com.oheers.fish.libs.jooq.impl.NoConnectionFactory;
import com.oheers.fish.libs.jooq.impl.ParamCollector;
import com.oheers.fish.libs.jooq.impl.R2DBC;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import io.r2dbc.spi.ConnectionFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.reactivestreams.Subscriber;

final class BatchSingle
extends AbstractBatch
implements BatchBindStep {
    private static final JooqLogger log = JooqLogger.getLogger(BatchSingle.class);
    final Query query;
    final Map<String, List<Integer>> nameToIndexMapping;
    final List<Object[]> allBindValues;
    final int expectedBindValues;

    public BatchSingle(Configuration configuration, Query query) {
        super(configuration);
        int i = 0;
        ParamCollector collector = new ParamCollector(configuration, false);
        collector.visit(query);
        this.query = query;
        this.allBindValues = new ArrayList<Object[]>();
        this.nameToIndexMapping = new LinkedHashMap<String, List<Integer>>();
        this.expectedBindValues = collector.resultList.size();
        for (Map.Entry<String, Param<?>> entry : collector.resultList) {
            this.nameToIndexMapping.computeIfAbsent(entry.getKey(), e -> new ArrayList()).add(i++);
        }
    }

    @Override
    public final BatchSingle bind(Object ... bindValues) {
        this.allBindValues.add(bindValues);
        return this;
    }

    @Override
    public final BatchSingle bind(Object[] ... bindValues) {
        for (Object[] v : bindValues) {
            this.bind(v);
        }
        return this;
    }

    @Override
    public final BatchSingle bind(Map<String, Object> namedBindValues) {
        return this.bind(new Map[]{namedBindValues});
    }

    @Override
    @SafeVarargs
    public final BatchSingle bind(Map<String, Object> ... namedBindValues) {
        List<Object> defaultValues = this.dsl.extractBindValues(this.query);
        Object[][] bindValues = new Object[namedBindValues.length][];
        for (int i = 0; i < bindValues.length; ++i) {
            bindValues[i] = defaultValues.toArray();
            Object[] row = bindValues[i];
            namedBindValues[i].forEach((k, v) -> {
                List<Integer> indexes = this.nameToIndexMapping.get(k);
                if (indexes != null) {
                    for (int index : indexes) {
                        row[index] = v;
                    }
                }
            });
        }
        this.bind(bindValues);
        return this;
    }

    @Override
    public final int size() {
        return this.allBindValues.size();
    }

    @Override
    public final void subscribe(Subscriber<? super Integer> subscriber) {
        ConnectionFactory cf = this.configuration.connectionFactory();
        if (cf instanceof NoConnectionFactory) {
            throw new UnsupportedOperationException("The blocking, JDBC backed implementation of reactive batching has not yet been implemented. Use the R2DBC backed implementation, instead, or avoid batching.");
        }
        subscriber.onSubscribe(new R2DBC.BatchSubscription<BatchSingle>(this, subscriber, s -> new R2DBC.BatchSingleSubscriber(this, (R2DBC.BatchSubscription<BatchSingle>)s)));
    }

    @Override
    public final int[] execute() {
        if (this.allBindValues.isEmpty()) {
            log.info((Object)"Single batch", "No bind variables have been provided with a single statement batch execution. This may be due to accidental API misuse");
            return BatchMultiple.execute(this.configuration, new Query[]{this.query});
        }
        this.checkBindValues();
        if (SettingsTools.executeStaticStatements(this.configuration.settings())) {
            return this.executeStatic();
        }
        return this.executePrepared();
    }

    final void checkBindValues() {
        if (this.expectedBindValues > 0) {
            for (int i = 0; i < this.allBindValues.size(); ++i) {
                if (this.allBindValues.get(i).length == this.expectedBindValues) continue;
                log.info((Object)"Bind value count", "Batch bind value set " + i + " has " + this.allBindValues.get(i).length + " values when " + this.expectedBindValues + " values were expected");
            }
        }
    }

    private final int[] executePrepared() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, ExecuteContext.BatchMode.SINGLE, new Query[]{this.query});
        ExecuteListener listener = ExecuteListeners.get(ctx, true);
        try {
            listener.start(ctx);
            ctx.transformQueries(listener);
            listener.renderStart(ctx);
            DefaultRenderContext.Rendered.rendered(this.configuration, ctx, ctx.batchQueries()[0], false, false).setSQLAndParams(ctx);
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            if (ctx.statement() == null) {
                ctx.statement(AbstractQuery.connection(ctx).prepareStatement(ctx.sql()));
            }
            listener.prepareEnd(ctx);
            int t = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t != 0) {
                ctx.statement().setQueryTimeout(t);
            }
            if (NO_SUPPORT_BATCH.contains((Object)ctx.dialect())) {
                int size = this.allBindValues.size();
                int[] result = new int[size];
                for (int i = 0; i < size; ++i) {
                    Object[] bindValues = this.allBindValues.get(i);
                    this.setBindValues(ctx, listener, ctx.params(), bindValues);
                    listener.executeStart(ctx);
                    result[i] = ctx.statement().executeUpdate();
                    listener.executeEnd(ctx);
                }
                this.setBatchRows(ctx, result);
                int[] nArray = result;
                return nArray;
            }
            AtomicBoolean reset = new AtomicBoolean();
            int[] nArray = Tools.chunks(this.allBindValues, SettingsTools.getBatchSize(ctx.settings())).stream().map(Tools.checkedFunction(chunk -> {
                if (reset.get()) {
                    ctx.statement().clearBatch();
                }
                for (Object[] bindValues : chunk) {
                    this.setBindValues(ctx, listener, ctx.params(), bindValues);
                    ctx.statement().addBatch();
                }
                listener.executeStart(ctx);
                int[] result = ctx.statement().executeBatch();
                this.setBatchRows(ctx, result);
                listener.executeEnd(ctx);
                reset.set(true);
                return result;
            })).flatMapToInt(IntStream::of).toArray();
            return nArray;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }

    private final void setBindValues(DefaultExecuteContext ctx, ExecuteListener listener, Param<?>[] params, Object[] bindValues) {
        listener.bindStart(ctx);
        Tools.visitAll(new DefaultBindContext(this.configuration, ctx, ctx.statement()), params.length > 0 ? Tools.fields(bindValues, params) : Tools.fields(bindValues));
        listener.bindEnd(ctx);
    }

    private final void setBatchRows(DefaultExecuteContext ctx, int[] result) {
        int[] batchRows = ctx.batchRows();
        for (int i = 0; i < batchRows.length && i < result.length; ++i) {
            batchRows[i] = result[i];
        }
    }

    final Param<?>[] extractParams() {
        ParamCollector collector = new ParamCollector(this.configuration, false);
        collector.visit(this.query);
        return Tools.map(collector.resultList, e -> (Param)e.getValue(), Param[]::new);
    }

    private final int[] executeStatic() {
        return this.batchMultiple().execute();
    }

    private final Batch batchMultiple() {
        ArrayList<RowCountQuery> queries = new ArrayList<RowCountQuery>(this.allBindValues.size());
        for (Object[] bindValues : this.allBindValues) {
            for (int i = 0; i < bindValues.length; ++i) {
                this.query.bind(i + 1, bindValues[i]);
            }
            queries.add(this.dsl.query(this.query.getSQL(ParamType.INLINED)));
        }
        return this.dsl.batch(queries);
    }

    public String toString() {
        return this.batchMultiple().toString();
    }
}

