/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Binding;
import com.oheers.fish.libs.jooq.BindingGetResultSetContext;
import com.oheers.fish.libs.jooq.BindingGetSQLInputContext;
import com.oheers.fish.libs.jooq.BindingGetStatementContext;
import com.oheers.fish.libs.jooq.BindingRegisterContext;
import com.oheers.fish.libs.jooq.BindingSQLContext;
import com.oheers.fish.libs.jooq.BindingSetSQLOutputContext;
import com.oheers.fish.libs.jooq.BindingSetStatementContext;
import com.oheers.fish.libs.jooq.Converter;
import com.oheers.fish.libs.jooq.Converters;
import com.oheers.fish.libs.jooq.ResourceManagingScope;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.impl.ClobBinding;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultExecuteContext;
import com.oheers.fish.libs.jooq.impl.R2DBC;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.jdbc.JDBCUtils;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;

public class BlobBinding
implements Binding<byte[], byte[]> {
    static final Set<SQLDialect> NO_SUPPORT_LOBS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    @Override
    public final Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    @Override
    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit(DSL.inline((Object)ctx.convert(this.converter()).value(), SQLDataType.BLOB));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    @Override
    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.statement().registerOutParameter(ctx.index(), 2004);
        } else {
            ctx.statement().registerOutParameter(ctx.index(), -2);
        }
    }

    @Override
    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        if (ctx.statement() instanceof R2DBC.R2DBCPreparedStatement) {
            ctx.statement().setBytes(ctx.index(), ctx.value());
        } else if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = BlobBinding.newBlob(ctx, ctx.value(), ctx.statement().getConnection());
            if (blob == null && ClobBinding.NO_SUPPORT_NULL_LOBS.contains((Object)ctx.dialect())) {
                ctx.statement().setNull(ctx.index(), 2004);
            } else {
                ctx.statement().setBlob(ctx.index(), blob);
            }
        } else {
            ctx.statement().setBytes(ctx.index(), ctx.value());
        }
    }

    @Override
    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.output().writeBlob(BlobBinding.newBlob(ctx, ctx.value(), null));
        } else {
            ctx.output().writeBytes(ctx.value());
        }
    }

    @Override
    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        if (ctx.resultSet() instanceof R2DBC.R2DBCResultSet) {
            ctx.value(ctx.resultSet().getBytes(ctx.index()));
        } else if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.resultSet().getBlob(ctx.index());
            try {
                ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        } else {
            ctx.value(ctx.resultSet().getBytes(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.statement().getBlob(ctx.index());
            try {
                ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        } else {
            ctx.value(ctx.statement().getBytes(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.input().readBlob();
            try {
                ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        } else {
            ctx.value(ctx.input().readBytes());
        }
    }

    static final Blob newBlob(ResourceManagingScope scope, byte[] bytes, Connection connection) throws SQLException {
        if (bytes == null) {
            return null;
        }
        switch (scope.dialect()) {
            default: 
        }
        Blob blob = (connection != null ? connection : DefaultExecuteContext.localConnection()).createBlob();
        scope.autoFree(blob);
        blob.setBytes(1L, bytes);
        return blob;
    }
}

