/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.JSONB;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class Contains<T>
extends AbstractCondition
implements QOM.Contains<T> {
    final Field<T> value;
    final Field<T> content;

    Contains(Field<T> value, Field<T> content) {
        this.value = Tools.nullableIf(false, Tools.nullSafe(value, content.getDataType()));
        this.content = Tools.nullableIf(false, Tools.nullSafe(content, value.getDataType()));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
            case DUCKDB: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.value.getDataType().isArray() || this.content.getDataType().isArray()) {
                    ctx.visit(this.value).sql(" @> ").visit(this.content);
                    break;
                }
                if (this.value.getDataType().getType() == JSONB.class || this.content.getDataType().getType() == JSONB.class) {
                    ctx.visit(this.value).sql(" @> ").visit(this.content);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            case DUCKDB: {
                ctx.visit(DSL.function(Names.N_CONTAINS, SQLDataType.BOOLEAN, this.value, this.content));
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(this.value.like(DSL.concat(DSL.inline("%"), Tools.escapeForLike(this.content, ctx.configuration()), DSL.inline("%")), '!'));
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<T> $arg2() {
        return this.content;
    }

    @Override
    public final QOM.Contains<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.Contains<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.Contains<T>> $constructor() {
        return (a1, a2) -> new Contains(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Contains) {
            QOM.Contains o = (QOM.Contains)that;
            return Objects.equals(this.$value(), o.$value()) && Objects.equals(this.$content(), o.$content());
        }
        return super.equals(that);
    }
}

