/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.UniqueKey;
import com.oheers.fish.libs.jooq.impl.AbstractAggregateFunction;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultAggregateFunction;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;

final class CountTable
extends AbstractAggregateFunction<Integer>
implements QOM.CountTable {
    private final Table<?> table;

    CountTable(Table<?> table, boolean distinct) {
        super(distinct, "count", SQLDataType.INTEGER, DSL.field(DSL.name(table.getName())));
        this.table = table;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                super.accept(ctx);
                break;
            }
            default: {
                UniqueKey<?> pk = this.table.getPrimaryKey();
                if (pk != null) {
                    ctx.visit(new DefaultAggregateFunction<Integer>(this.distinct, "count", SQLDataType.INTEGER, this.table.fields(pk.getFieldsArray())));
                    break;
                }
                super.accept(ctx);
                break;
            }
        }
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }
}

