/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Comment;
import com.oheers.fish.libs.jooq.Condition;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Constraint;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.CreateTableAsStep;
import com.oheers.fish.libs.jooq.CreateTableCommentStep;
import com.oheers.fish.libs.jooq.CreateTableElementListStep;
import com.oheers.fish.libs.jooq.CreateTableFinalStep;
import com.oheers.fish.libs.jooq.CreateTableOnCommitStep;
import com.oheers.fish.libs.jooq.CreateTableStorageStep;
import com.oheers.fish.libs.jooq.CreateTableWithDataStep;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.EnumType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function9;
import com.oheers.fish.libs.jooq.Index;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.Nullability;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.SQL;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableElement;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.ConstraintImpl;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.SortFieldList;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class CreateTableImpl
extends AbstractDDLQuery
implements QOM.CreateTable,
CreateTableElementListStep,
CreateTableAsStep,
CreateTableWithDataStep,
CreateTableOnCommitStep,
CreateTableCommentStep,
CreateTableStorageStep,
CreateTableFinalStep {
    final Table<?> table;
    final boolean temporary;
    final boolean ifNotExists;
    QueryPartListView<? extends TableElement> tableElements;
    Select<?> select;
    QOM.WithOrWithoutData withData;
    QOM.TableCommitAction onCommit;
    Comment comment;
    SQL storage;
    static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    static final Set<SQLDialect> NO_SUPPORT_WITH_DATA = SQLDialect.supportedBy(SQLDialect.DUCKDB, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_CTAS_COLUMN_NAMES = SQLDialect.supportedBy(SQLDialect.H2);
    static final Set<SQLDialect> EMULATE_INDEXES_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_SOME_ENUM_TYPES_AS_CHECK = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_STORED_ENUM_TYPES_AS_CHECK = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.SQLITE);
    static final Set<SQLDialect> REQUIRES_WITH_DATA = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    static final Set<SQLDialect> WRAP_SELECT_IN_PARENS = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    static final Set<SQLDialect> SUPPORT_TEMPORARY = SQLDialect.supportedBy(SQLDialect.DUCKDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_TABLE_COMMENT_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_COLUMN_COMMENT_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> REQUIRE_EXECUTE_IMMEDIATE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> NO_SUPPORT_NULLABLE_PRIMARY_KEY = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    static final Set<SQLDialect> REQUIRE_NON_PK_COLUMNS = SQLDialect.supportedBy(SQLDialect.IGNITE);

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary, boolean ifNotExists) {
        this(configuration, table, temporary, ifNotExists, null, null, null, null, null, null);
    }

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary, boolean ifNotExists, Collection<? extends TableElement> tableElements, Select<?> select, QOM.WithOrWithoutData withData, QOM.TableCommitAction onCommit, Comment comment, SQL storage) {
        super(configuration);
        this.table = table;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.tableElements = new QueryPartList<TableElement>((Iterable<? extends TableElement>)tableElements);
        this.select = select;
        this.withData = withData;
        this.onCommit = onCommit;
        this.comment = comment;
        this.storage = storage;
    }

    @Override
    public final CreateTableImpl tableElements(TableElement ... tableElements) {
        return this.tableElements(Arrays.asList(tableElements));
    }

    @Override
    public final CreateTableImpl tableElements(Collection<? extends TableElement> tableElements) {
        if (this.tableElements == null) {
            this.tableElements = new QueryPartList<TableElement>((Iterable<? extends TableElement>)tableElements);
        } else {
            this.tableElements.addAll(tableElements);
        }
        return this;
    }

    @Override
    public final CreateTableImpl columns(String ... columns) {
        return this.columns(Tools.fieldsByName(columns));
    }

    @Override
    public final CreateTableImpl columns(Name ... columns) {
        return this.columns(Tools.fieldsByName(columns));
    }

    @Override
    public final CreateTableImpl columns(Field<?> ... columns) {
        return this.columns(Arrays.asList(columns));
    }

    @Override
    public final CreateTableImpl columns(Collection<? extends Field<?>> columns) {
        return this.tableElements((Collection)new QueryPartList((Iterable<? extends Field<?>>)columns));
    }

    @Override
    public final CreateTableImpl column(Field<?> column) {
        return this.tableElements(column);
    }

    @Override
    public final CreateTableImpl column(String field, DataType<?> type) {
        return this.column(DSL.name(field), (DataType)type);
    }

    @Override
    public final CreateTableImpl column(Name field, DataType<?> type) {
        return this.tableElements(DSL.field(field, type));
    }

    @Override
    public final CreateTableImpl column(Field<?> field, DataType<?> type) {
        return this.tableElements(DSL.field(field.getQualifiedName(), type));
    }

    @Override
    public final CreateTableImpl constraints(Constraint ... constraints) {
        return this.constraints(Arrays.asList(constraints));
    }

    @Override
    public final CreateTableImpl constraints(Collection<? extends Constraint> constraints) {
        return this.tableElements(new QueryPartList<Constraint>((Iterable<? extends Constraint>)constraints));
    }

    @Override
    public final CreateTableImpl constraint(Constraint constraint) {
        return this.tableElements(constraint);
    }

    @Override
    public final CreateTableImpl primaryKey(String ... fields) {
        return this.primaryKey(Tools.fieldsByName(fields));
    }

    @Override
    public final CreateTableImpl primaryKey(Name ... fields) {
        return this.primaryKey(Tools.fieldsByName(fields));
    }

    @Override
    public final CreateTableImpl primaryKey(Field<?> ... fields) {
        return this.primaryKey(Arrays.asList(fields));
    }

    @Override
    public final CreateTableImpl primaryKey(Collection<? extends Field<?>> fields) {
        return this.tableElements(DSL.primaryKey(new QueryPartList((Iterable<? extends Field<?>>)fields)));
    }

    @Override
    public final CreateTableImpl unique(String ... fields) {
        return this.unique(Tools.fieldsByName(fields));
    }

    @Override
    public final CreateTableImpl unique(Name ... fields) {
        return this.unique(Tools.fieldsByName(fields));
    }

    @Override
    public final CreateTableImpl unique(Field<?> ... fields) {
        return this.unique(Arrays.asList(fields));
    }

    @Override
    public final CreateTableImpl unique(Collection<? extends Field<?>> fields) {
        return this.tableElements(DSL.unique(new QueryPartList((Iterable<? extends Field<?>>)fields)));
    }

    @Override
    public final CreateTableImpl check(Condition condition) {
        return this.tableElements(DSL.check(condition));
    }

    @Override
    public final CreateTableImpl indexes(Index ... indexes) {
        return this.indexes(Arrays.asList(indexes));
    }

    @Override
    public final CreateTableImpl indexes(Collection<? extends Index> indexes) {
        return this.tableElements(new QueryPartList<Index>((Iterable<? extends Index>)indexes));
    }

    @Override
    public final CreateTableImpl index(Index index) {
        return this.tableElements(index);
    }

    @Override
    public final CreateTableImpl as(Select<?> select) {
        this.select = select;
        return this;
    }

    @Override
    public final CreateTableImpl withData() {
        this.withData = QOM.WithOrWithoutData.WITH_DATA;
        return this;
    }

    @Override
    public final CreateTableImpl withNoData() {
        this.withData = QOM.WithOrWithoutData.WITH_NO_DATA;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitDeleteRows() {
        this.onCommit = QOM.TableCommitAction.DELETE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitPreserveRows() {
        this.onCommit = QOM.TableCommitAction.PRESERVE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitDrop() {
        this.onCommit = QOM.TableCommitAction.DROP;
        return this;
    }

    @Override
    public final CreateTableImpl comment(String comment) {
        return this.comment(DSL.comment(comment));
    }

    @Override
    public final CreateTableImpl comment(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final CreateTableImpl storage(SQL storage) {
        this.storage = storage;
        return this;
    }

    @Override
    public final CreateTableImpl storage(String storage, QueryPart ... parts) {
        return this.storage(DSL.sql(storage, parts));
    }

    @Override
    public final CreateTableImpl storage(String storage, Object ... bindings) {
        return this.storage(DSL.sql(storage, bindings));
    }

    @Override
    public final CreateTableImpl storage(String storage) {
        return this.storage(DSL.sql(storage));
    }

    final QOM.UnmodifiableList<? extends Field<?>> $columns() {
        return QOM.unmodifiable(Tools.map(Tools.filter(this.tableElements, e -> e instanceof Field), e -> (Field)e));
    }

    final QOM.UnmodifiableList<? extends Constraint> $constraints() {
        return QOM.unmodifiable(Tools.map(Tools.filter(this.tableElements, e -> e instanceof Constraint), e -> (Constraint)e));
    }

    final QOM.UnmodifiableList<? extends Index> $indexes() {
        return QOM.unmodifiable(Tools.map(Tools.filter(this.tableElements, e -> e instanceof Index), e -> (Index)e));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_TABLE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean bi;
        boolean btc = this.comment != null && EMULATE_TABLE_COMMENT_IN_BLOCK.contains((Object)ctx.dialect());
        boolean bcc = EMULATE_COLUMN_COMMENT_IN_BLOCK.contains((Object)ctx.dialect()) && Tools.anyMatch(this.$columns(), c -> !c.getComment().isEmpty());
        boolean bl = bi = !this.$indexes().isEmpty() && EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.dialect());
        if (btc || bcc || bi) {
            Tools.begin(ctx, c1 -> {
                Tools.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)c1.dialect()), c1, c2 -> this.accept1((Context<?>)c2));
                if (btc) {
                    c1.formatSeparator();
                    Tools.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect()), c1, c2 -> c2.visit(DSL.commentOnTable(this.table).is(this.comment)));
                }
                if (bcc) {
                    c1.formatSeparator();
                    for (Field field : this.$columns()) {
                        if (field.getComment().isEmpty()) continue;
                        Tools.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect()), c1, c2 -> c2.visit(DSL.commentOnColumn(this.table.getQualifiedName().append(c.getUnqualifiedName())).is(c.getComment())));
                    }
                }
                if (bi) {
                    for (Index index : this.$indexes()) {
                        c1.formatSeparator();
                        Tools.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)c1.dialect()), c1, c2 -> {
                            if ("".equals(index.getName())) {
                                c2.visit(DSL.createIndex().on(index.getTable(), index.getFields()));
                            } else {
                                c2.visit(DSL.createIndex(index.getUnqualifiedName()).on(index.getTable(), index.getFields()));
                            }
                        });
                    }
                }
            });
        } else {
            this.accept1(ctx);
        }
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE);
        if (this.select != null) {
            this.acceptCreateTableAsSelect(ctx);
        } else {
            this.toSQLCreateTable(ctx);
            this.toSQLOnCommit(ctx);
        }
        if (this.comment != null && !EMULATE_TABLE_COMMENT_IN_BLOCK.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_COMMENT).sql(' ');
            ctx.visit(this.comment);
        }
        if (this.storage != null && ctx.configuration().data("com.oheers.fish.libs.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(this.storage);
        }
        ctx.end(Clause.CREATE_TABLE);
    }

    private void toSQLCreateTable(Context<?> ctx) {
        this.toSQLCreateTableName(ctx);
        QOM.UnmodifiableList<Field<?>> columns = this.$columns();
        if (!(columns.isEmpty() || this.select != null && NO_SUPPORT_CTAS_COLUMN_NAMES.contains((Object)ctx.dialect()))) {
            DataType<Object> type;
            ctx.sqlIndentStart(" (").start(Clause.CREATE_TABLE_COLUMNS);
            Field identity = null;
            boolean qualify = ctx.qualify();
            boolean first = true;
            for (int i = 0; i < columns.size(); ++i) {
                Field field = (Field)columns.get(i);
                type = this.columnType(ctx, field);
                if (type.computedOnClientVirtual(ctx.configuration())) continue;
                if (identity == null && type.identity()) {
                    identity = field;
                }
                if (!first) {
                    ctx.sql(',').formatSeparator();
                }
                ctx.qualify(false);
                ctx.visit(Tools.uncollate(field));
                ctx.qualify(qualify);
                if (this.select == null) {
                    ctx.sql(' ');
                    Tools.toSQLDDLTypeDeclarationForAddition(ctx, type);
                    CreateTableImpl.acceptColumnComment(ctx, field);
                }
                first = false;
            }
            this.toSQLDummyColumns(ctx);
            ctx.end(Clause.CREATE_TABLE_COLUMNS).start(Clause.CREATE_TABLE_CONSTRAINTS);
            for (Constraint constraint : this.$constraints()) {
                if (!((ConstraintImpl)constraint).supported(ctx) || ctx.family() == SQLDialect.SQLITE && this.matchingPrimaryKey(constraint, identity)) continue;
                ctx.sql(',').formatSeparator().visit(constraint);
            }
            if (EMULATE_SOME_ENUM_TYPES_AS_CHECK.contains((Object)ctx.dialect())) {
                for (Field field : this.$columns()) {
                    type = field.getDataType();
                    if (!EnumType.class.isAssignableFrom(type.getType())) continue;
                    DataType<Object> enumType = type;
                    if (!EMULATE_STORED_ENUM_TYPES_AS_CHECK.contains((Object)ctx.dialect()) && Tools.storedEnumType(enumType)) continue;
                    List<Field> literals = Tools.map(Tools.enums(enumType.getType()), e -> DSL.inline(e.getLiteral()));
                    ctx.sql(',').formatSeparator().visit(DSL.constraint(this.table.getName() + "_" + field.getName() + "_chk").check(field.in((Collection<?>)literals)));
                }
            }
            ctx.end(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.$indexes().isEmpty() && !EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.dialect())) {
                ctx.qualify(false);
                for (Index index : this.$indexes()) {
                    ctx.sql(',').formatSeparator();
                    if (index.getUnique()) {
                        ctx.visit(Keywords.K_UNIQUE).sql(' ');
                    }
                    ctx.visit(Keywords.K_INDEX);
                    if (!"".equals(index.getName())) {
                        ctx.sql(' ').visit(index.getUnqualifiedName());
                    }
                    ctx.sql(" (").visit(new SortFieldList(index.getFields())).sql(')');
                }
                ctx.qualify(qualify);
            }
            ctx.sqlIndentEnd(')');
        }
    }

    static void acceptColumnComment(Context<?> ctx, Field<?> field) {
        if (!field.getComment().isEmpty() && !EMULATE_COLUMN_COMMENT_IN_BLOCK.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_COMMENT).sql(' ').visit(DSL.inline(field.getComment()));
        }
    }

    private final void toSQLDummyColumns(Context<?> ctx) {
        Field<?>[] primaryKeyColumns;
        if (REQUIRE_NON_PK_COLUMNS.contains((Object)ctx.dialect()) && (primaryKeyColumns = this.primaryKeyColumns()) != null && primaryKeyColumns.length == this.$columns().size()) {
            ctx.sql(',').formatSeparator();
            ctx.visit(DSL.field(DSL.name("dummy")));
            if (this.select == null) {
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclarationForAddition(ctx, SQLDataType.INTEGER);
            }
        }
    }

    private final DataType<?> columnType(Context<?> ctx, Field<?> field) {
        DataType type = field.getDataType();
        if (NO_SUPPORT_NULLABLE_PRIMARY_KEY.contains((Object)ctx.dialect()) && type.nullability() == Nullability.DEFAULT && this.isPrimaryKey(field)) {
            type = type.nullable(false);
        }
        return type;
    }

    private final Field<?>[] primaryKeyColumns() {
        return Tools.findAny(this.$constraints(), c -> c instanceof ConstraintImpl && ((ConstraintImpl)c).$primaryKey() != null, c -> ((ConstraintImpl)c).$primaryKey());
    }

    private final boolean isPrimaryKey(Field<?> field) {
        return Tools.anyMatch(this.primaryKeyColumns(), field::equals);
    }

    private final boolean matchingPrimaryKey(Constraint constraint, Field<?> identity) {
        if (constraint instanceof ConstraintImpl) {
            ConstraintImpl c = (ConstraintImpl)constraint;
            return c.matchingPrimaryKey(identity);
        }
        return false;
    }

    private final void acceptCreateTableAsSelect(Context<?> ctx) {
        this.toSQLCreateTable(ctx);
        this.toSQLOnCommit(ctx);
        ctx.formatSeparator().visit(Keywords.K_AS);
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.dialect())) {
            ctx.sqlIndentStart(" (");
        } else {
            ctx.formatSeparator();
        }
        if (QOM.WithOrWithoutData.WITH_NO_DATA == this.withData && NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.data(Tools.BooleanDataKey.DATA_SELECT_NO_DATA, true);
        }
        ctx.start(Clause.CREATE_TABLE_AS);
        if (!this.$columns().isEmpty() && NO_SUPPORT_CTAS_COLUMN_NAMES.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)this.select.asTable(DSL.table(DSL.name("t")), this.$columns())));
        } else {
            ctx.visit(this.select);
        }
        ctx.end(Clause.CREATE_TABLE_AS);
        if (QOM.WithOrWithoutData.WITH_NO_DATA == this.withData && NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.data().remove(Tools.BooleanDataKey.DATA_SELECT_NO_DATA);
        }
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.dialect())) {
            ctx.sqlIndentEnd(')');
        }
        if (QOM.WithOrWithoutData.WITH_NO_DATA == this.withData && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_NO_DATA);
        } else if (QOM.WithOrWithoutData.WITH_DATA == this.withData && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_DATA);
        } else if (REQUIRES_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_DATA);
        }
    }

    private final void toSQLCreateTableName(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE_NAME).visit(Keywords.K_CREATE).sql(' ');
        if (this.temporary) {
            if (SUPPORT_TEMPORARY.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_TEMPORARY).sql(' ');
            } else {
                ctx.visit(Keywords.K_GLOBAL_TEMPORARY).sql(' ');
            }
        }
        ctx.visit(Keywords.K_TABLE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.table).end(Clause.CREATE_TABLE_NAME);
    }

    private final void toSQLOnCommit(Context<?> ctx) {
        if (this.temporary && this.onCommit != null) {
            switch (this.onCommit) {
                case DELETE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DELETE_ROWS);
                    break;
                }
                case PRESERVE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_PRESERVE_ROWS);
                    break;
                }
                case DROP: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DROP);
                }
            }
        }
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }

    @Override
    public final boolean $temporary() {
        return this.temporary;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final QOM.UnmodifiableList<? extends TableElement> $tableElements() {
        return QOM.unmodifiable(this.tableElements);
    }

    @Override
    public final Select<?> $select() {
        return this.select;
    }

    @Override
    public final QOM.WithOrWithoutData $withData() {
        return this.withData;
    }

    @Override
    public final QOM.TableCommitAction $onCommit() {
        return this.onCommit;
    }

    @Override
    public final Comment $comment() {
        return this.comment;
    }

    @Override
    public final SQL $storage() {
        return this.storage;
    }

    @Override
    public final QOM.CreateTable $table(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$temporary(), this.$ifNotExists(), this.$tableElements(), this.$select(), this.$withData(), this.$onCommit(), this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $temporary(boolean newValue) {
        return this.$constructor().apply(this.$table(), newValue, this.$ifNotExists(), this.$tableElements(), this.$select(), this.$withData(), this.$onCommit(), this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $ifNotExists(boolean newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), newValue, this.$tableElements(), this.$select(), this.$withData(), this.$onCommit(), this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $tableElements(Collection<? extends TableElement> newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), this.$ifNotExists(), newValue, this.$select(), this.$withData(), this.$onCommit(), this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $select(Select<?> newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), this.$ifNotExists(), this.$tableElements(), newValue, this.$withData(), this.$onCommit(), this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $withData(QOM.WithOrWithoutData newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), this.$ifNotExists(), this.$tableElements(), this.$select(), newValue, this.$onCommit(), this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $onCommit(QOM.TableCommitAction newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), this.$ifNotExists(), this.$tableElements(), this.$select(), this.$withData(), newValue, this.$comment(), this.$storage());
    }

    @Override
    public final QOM.CreateTable $comment(Comment newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), this.$ifNotExists(), this.$tableElements(), this.$select(), this.$withData(), this.$onCommit(), newValue, this.$storage());
    }

    @Override
    public final QOM.CreateTable $storage(SQL newValue) {
        return this.$constructor().apply(this.$table(), this.$temporary(), this.$ifNotExists(), this.$tableElements(), this.$select(), this.$withData(), this.$onCommit(), this.$comment(), newValue);
    }

    public final Function9<? super Table<?>, ? super Boolean, ? super Boolean, ? super Collection<? extends TableElement>, ? super Select<?>, ? super QOM.WithOrWithoutData, ? super QOM.TableCommitAction, ? super Comment, ? super SQL, ? extends QOM.CreateTable> $constructor() {
        return (a1, a2, a3, a4, a5, a6, a7, a8, a9) -> new CreateTableImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (boolean)a3, (Collection<? extends TableElement>)a4, (Select<?>)a5, (QOM.WithOrWithoutData)((Object)a6), (QOM.TableCommitAction)((Object)a7), (Comment)a8, (SQL)a9);
    }
}

