/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Keyword;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;

final class DateOrTime<T>
extends AbstractField<T>
implements QOM.UNotYetImplemented {
    private final Field<?> field;

    DateOrTime(Field<?> field, DataType<T> dataType) {
        super(DSL.name(DateOrTime.name(dataType)), dataType);
        this.field = field;
    }

    private static String name(DataType<?> dataType) {
        return dataType.isDate() ? "date" : (dataType.isTime() ? "time" : "timestamp");
    }

    private static Keyword keyword(DataType<?> dataType) {
        return dataType.isDate() ? Keywords.K_DATE : (dataType.isTime() ? Keywords.K_TIME : Keywords.K_TIMESTAMP);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DateOrTime.keyword(this.getDataType())).sql('(').visit(this.field).sql(')');
                break;
            }
            case SQLITE: {
                if (this.getDataType().isDate()) {
                    ctx.visit(Keywords.K_DATE).sql('(').visit(this.field).sql(')');
                    break;
                }
                if (this.getDataType().isTime()) {
                    ctx.visit(Keywords.K_TIME).sql('(').visit(this.field).sql(')');
                    break;
                }
                ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.field).sql(')');
                break;
            }
            default: {
                ctx.visit(Tools.castIfNeeded(this.field, this.getDataType()));
            }
        }
    }
}

