/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DropSequenceFinalStep;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Sequence;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class DropSequenceImpl
extends AbstractDDLQuery
implements QOM.DropSequence,
DropSequenceFinalStep {
    final Sequence<?> sequence;
    final boolean ifExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_SEQUENCE};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropSequenceImpl(Configuration configuration, Sequence<?> sequence, boolean ifExists) {
        super(configuration);
        this.sequence = sequence;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_SEQUENCE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_SEQUENCE_SEQUENCE).visit(Keywords.K_DROP).sql(' ').visit(ctx.family() == SQLDialect.CUBRID ? Keywords.K_SERIAL : Keywords.K_SEQUENCE);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.sequence);
        if (ctx.family() == SQLDialect.DERBY) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.DROP_SEQUENCE_SEQUENCE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Sequence<?> $sequence() {
        return this.sequence;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.DropSequence $sequence(Sequence<?> newValue) {
        return this.$constructor().apply(newValue, this.$ifExists());
    }

    @Override
    public final QOM.DropSequence $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$sequence(), newValue);
    }

    public final Function2<? super Sequence<?>, ? super Boolean, ? extends QOM.DropSequence> $constructor() {
        return (a1, a2) -> new DropSequenceImpl(this.configuration(), (Sequence<?>)a1, (boolean)a2);
    }
}

