/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.JSON;
import com.oheers.fish.libs.jooq.JSONEntry;
import com.oheers.fish.libs.jooq.JSONObjectAggNullStep;
import com.oheers.fish.libs.jooq.JSONObjectNullStep;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.impl.AbstractAggregateFunction;
import com.oheers.fish.libs.jooq.impl.CustomField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.JSONEntryImpl;
import com.oheers.fish.libs.jooq.impl.JSONNull;
import com.oheers.fish.libs.jooq.impl.JSONReturning;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.RegexpReplace;
import com.oheers.fish.libs.jooq.impl.SQLDataType;

final class JSONObjectAgg<J>
extends AbstractAggregateFunction<J>
implements JSONObjectAggNullStep<J>,
QOM.JSONObjectAgg<J> {
    private final JSONEntry<?> entry;
    private QOM.JSONOnNull onNull;
    private DataType<?> returning;

    JSONObjectAgg(DataType<J> type, JSONEntry<?> entry) {
        super(false, Names.N_JSON_OBJECTAGG, type, entry.key(), entry.value());
        this.entry = entry;
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.acceptPostgres(ctx);
                break;
            }
            case MARIADB: 
            case MYSQL: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL || this.filter.hasWhere()) {
                    this.acceptGroupConcat(ctx);
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            case SQLITE: {
                this.acceptSQLite(ctx);
                break;
            }
            case TRINO: {
                this.acceptTrino(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final void acceptTrino(Context<?> ctx) {
        boolean noAggregateFilter;
        ctx.visit(Names.N_CAST).sql('(');
        boolean bl = noAggregateFilter = this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL && !this.supportsFilter(ctx);
        if (noAggregateFilter) {
            ctx.visit(Names.N_MAP_FILTER).sql('(');
        }
        ctx.visit(Names.N_MAP).sql('(');
        this.acceptTrinoArrayAgg(ctx, this.entry.key(), this.entry.value());
        ctx.sql(", ");
        this.acceptTrinoArrayAgg(ctx, this.entry.value(), this.entry.value());
        ctx.sql(')');
        if (noAggregateFilter) {
            ctx.sql(", (k, v) -> v ").visit(Keywords.K_IS_NOT_NULL).sql(')');
        }
        ctx.sql(' ').visit(Keywords.K_AS).sql(' ').visit(SQLDataType.JSON);
        ctx.sql(')');
    }

    private final void acceptTrinoArrayAgg(Context<?> ctx, Field<?> f1, Field<?> f2) {
        ctx.visit(Names.N_ARRAY_AGG).sql('(');
        ctx.visit(JSONEntryImpl.jsonCast(ctx, f1));
        ctx.sql(")");
        if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
            this.acceptFilterClause(ctx, this.f(f2.isNotNull()));
        } else {
            this.acceptFilterClause(ctx);
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptPostgres(Context<?> ctx) {
        ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_OBJECT_AGG : Names.N_JSONB_OBJECT_AGG).sql('(');
        ctx.visit(this.entry);
        ctx.sql(')');
        if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
            this.acceptFilterClause(ctx, this.f(this.entry.value().isNotNull()));
        } else {
            this.acceptFilterClause(ctx);
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptSQLite(Context<?> ctx) {
        ctx.visit(Names.N_JSON_GROUP_OBJECT).sql('(');
        ctx.visit(this.entry);
        ctx.sql(')');
        if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
            this.acceptFilterClause(ctx, this.f(this.entry.value().isNotNull()));
        } else {
            this.acceptFilterClause(ctx);
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptGroupConcat(Context<?> ctx) {
        ctx.sql('(').visit(this.groupConcatEmulation(ctx)).sql(')');
    }

    private final Field<?> groupConcatEmulation(Context<?> ctx) {
        CustomField<String> listagg = CustomField.of(Names.N_GROUP_CONCAT, SQLDataType.VARCHAR, c1 -> {
            Field<JSON> o1 = DSL.jsonObject(this.entry.key(), this.entry.value());
            if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                o1 = DSL.when(this.entry.value().isNull(), DSL.inline((JSON)null)).else_(o1);
            }
            JSONObjectNullStep<JSON> o2 = o1;
            c1.visit(DSL.groupConcat(DSL.concat(CustomField.of(Names.N_FIELD, SQLDataType.VARCHAR, c2 -> this.acceptArguments2((Context<?>)c2, QueryPartListView.wrap((QueryPart[])new Field[]{DSL.regexpReplaceAll(o2.cast(SQLDataType.VARCHAR), DSL.inline("^\\{(.*)\\}$"), DSL.inline(RegexpReplace.replacement(ctx, 1)))}))))));
            this.acceptFilterClause((Context<?>)c1);
            this.acceptOverClause((Context<?>)c1);
        });
        Field<String> result = DSL.concat(DSL.inline('{'), listagg, DSL.inline('}'));
        switch (ctx.family()) {
            default: 
        }
        return result;
    }

    private final void acceptStandard(Context<?> ctx) {
        JSONReturning jsonReturning;
        ctx.visit(Names.N_JSON_OBJECTAGG).sql('(').visit(this.entry);
        JSONNull jsonNull = new JSONNull(this.onNull);
        if (jsonNull.rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonNull);
        }
        if ((jsonReturning = new JSONReturning(this.returning)).rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonReturning);
        }
        ctx.sql(')');
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    @Override
    public final JSONObjectAgg<J> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONObjectAgg<J> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONObjectAgg<J> returning(DataType<?> r) {
        this.returning = r;
        return this;
    }

    @Override
    public final JSONEntry<?> $arg1() {
        return this.entry;
    }

    @Override
    public final QOM.JSONOnNull $onNull() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $returning() {
        return this.returning;
    }

    @Override
    public final Function1<? super JSONEntry<?>, ? extends QOM.JSONObjectAgg<J>> $constructor() {
        return e -> {
            JSONObjectAgg r = new JSONObjectAgg(this.getDataType(), (JSONEntry<?>)e);
            r.onNull = this.onNull;
            r.returning = this.returning;
            return r;
        };
    }
}

