/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.Param;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.RenderContext;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.conf.SettingsTools;
import com.oheers.fish.libs.jooq.exception.DataAccessException;
import com.oheers.fish.libs.jooq.exception.DetachedException;
import com.oheers.fish.libs.jooq.impl.Cache;
import com.oheers.fish.libs.jooq.impl.CacheType;
import com.oheers.fish.libs.jooq.impl.DefaultBindContext;
import com.oheers.fish.libs.jooq.impl.DefaultRenderContext;
import com.oheers.fish.libs.jooq.impl.NoConnectionFactory;
import com.oheers.fish.libs.jooq.impl.ParsingStatement;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.SettingsEnabledConnection;
import com.oheers.fish.libs.jooq.impl.ThrowingFunction;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.Val;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import com.oheers.fish.libs.jooq.tools.jdbc.DefaultConnection;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class ParsingConnection
extends DefaultConnection {
    private static final JooqLogger log = JooqLogger.getLogger(ParsingConnection.class);
    final Configuration configuration;

    ParsingConnection(Configuration configuration) {
        super(new SettingsEnabledConnection(configuration.connectionProvider().acquire(), configuration.settings(), null, SettingsTools.getParamType(configuration.settings()) == ParamType.INLINED));
        if (((SettingsEnabledConnection)this.getDelegate()).getDelegate() == null) {
            if (configuration.connectionFactory() instanceof NoConnectionFactory) {
                throw new DetachedException("ConnectionProvider did not provide a JDBC Connection");
            }
            throw new DetachedException("Attempt to use a ParsingConnection (JDBC) when only an R2BDC ConnectionFactory was configured. Using ParsingConnectionFactory instead.");
        }
        this.configuration = configuration;
    }

    static final DefaultRenderContext.Rendered translate(Configuration configuration, String sql, Param<?> ... bindValues) {
        log.debug((Object)"Translating from", sql);
        DefaultRenderContext.Rendered result = null;
        Supplier<CacheValue> miss = () -> {
            log.debug((Object)"Translation cache miss", sql);
            return new CacheValue(configuration, sql, bindValues);
        };
        Settings settings = configuration.settings();
        if (CacheType.CACHE_PARSING_CONNECTION.category.predicate.test(settings) && bindValues.length > 0) {
            switch (SettingsTools.getParamType(settings)) {
                case INLINED: 
                case NAMED_OR_INLINED: {
                    result = miss.get().rendered(bindValues);
                }
            }
        }
        if (result == null) {
            result = Cache.run(configuration, miss, CacheType.CACHE_PARSING_CONNECTION, () -> Cache.key(sql, Tools.map(ParsingConnection.nonNull(bindValues), f -> f.getDataType()))).rendered(bindValues);
        }
        log.debug((Object)"Translating to", result.sql);
        return result;
    }

    private static Param<?>[] nonNull(Param<?>[] bindValues) {
        for (int i = 0; i < bindValues.length; ++i) {
            if (bindValues[i] != null) continue;
            throw new DataAccessException("Bind value at position " + i + " not set");
        }
        return bindValues;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return new ParsingStatement(this, this.getDelegate().createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    private final ThrowingFunction<List<List<Param<?>>>, PreparedStatement, SQLException> prepareAndBind(String sql, ThrowingFunction<String, PreparedStatement, SQLException> prepare) {
        return p -> {
            int size = p.size();
            DefaultRenderContext.Rendered rendered = size == 0 ? ParsingConnection.translate(this.configuration, sql, new Param[0]) : ParsingConnection.translate(this.configuration, sql, ((List)p.get(0)).toArray(Tools.EMPTY_PARAM));
            PreparedStatement s = (PreparedStatement)prepare.apply(rendered.sql);
            boolean inlined = SettingsTools.getParamType(this.configuration.settings()) == ParamType.INLINED;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    rendered = ParsingConnection.translate(this.configuration, sql, ((List)p.get(i)).toArray(Tools.EMPTY_PARAM));
                }
                if (!inlined) {
                    new DefaultBindContext(this.configuration, null, s).visit(rendered.bindValues);
                }
                if (size <= 1 && !(p instanceof ArrayList)) continue;
                if (!inlined) {
                    s.addBatch();
                    continue;
                }
                s.addBatch(rendered.sql);
            }
            return s;
        };
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareStatement((String)s)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareStatement((String)s, resultSetType, resultSetConcurrency)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareStatement((String)s, resultSetType, resultSetConcurrency, resultSetHoldability)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareStatement((String)s, autoGeneratedKeys)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareStatement((String)s, columnIndexes)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareStatement((String)s, columnNames)));
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareCall((String)s)));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareCall((String)s, resultSetType, resultSetConcurrency)));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ParsingStatement(this, this.prepareAndBind(sql, s -> this.getDelegate().prepareCall((String)s, resultSetType, resultSetConcurrency, resultSetHoldability)));
    }

    @Override
    public final void close() throws SQLException {
        this.configuration.connectionProvider().release(this.getDelegate());
    }

    static final class CacheValue {
        final String output;
        final int bindSize;
        final Map<Integer, List<Integer>> bindMapping;

        CacheValue(Configuration configuration, String input, Param<?>[] bindValues) {
            DSLContext ctx = configuration.dsl();
            DefaultRenderContext render = (DefaultRenderContext)ctx.renderContext();
            ((RenderContext)render.paramType(configuration.settings().getParamType())).visit(ctx.parser().parseQuery(input, bindValues));
            this.output = render.render();
            this.bindSize = render.bindValues().size();
            this.bindMapping = new HashMap<Integer, List<Integer>>();
            for (int j = 0; j < render.bindValues().size(); ++j) {
                Object object = render.bindValues().get(j);
                if (!(object instanceof Val)) continue;
                Val v = (Val)object;
                if (v.index > bindValues.length) continue;
                this.bindMapping.computeIfAbsent(v.index - 1, x -> new ArrayList()).add(j);
            }
        }

        DefaultRenderContext.Rendered rendered(Param<?> ... bindValues) {
            QueryPart[] binds = new Param[this.bindSize];
            for (int i = 0; i < bindValues.length; ++i) {
                Iterator iterator = this.bindMapping.getOrDefault(i, Collections.emptyList()).iterator();
                while (iterator.hasNext()) {
                    int mapped = (Integer)iterator.next();
                    binds[mapped] = bindValues[i];
                }
            }
            return new DefaultRenderContext.Rendered(this.output, new QueryPartList(binds), 0);
        }

        public String toString() {
            return this.output;
        }
    }
}

