/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class Shl<T extends Number>
extends AbstractField<T>
implements QOM.Shl<T> {
    final Field<T> value;
    final Field<? extends Number> count;

    Shl(Field<T> value, Field<? extends Number> count) {
        super(Names.N_SHL, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, count));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.count = Tools.nullSafeNotNull(count, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                return true;
            }
            case H2: {
                return true;
            }
            case TRINO: {
                return true;
            }
            case HSQLDB: {
                return false;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(DSL.function(Names.N_BIN_SHL, this.getDataType(), this.value, this.count));
                break;
            }
            case H2: {
                ctx.visit(DSL.function(Names.N_LSHIFT, this.getDataType(), this.value, this.count));
                break;
            }
            case TRINO: {
                ctx.visit(DSL.function(Names.N_BITWISE_LEFT_SHIFT, this.getDataType(), this.value, this.count));
                break;
            }
            case HSQLDB: {
                ctx.visit(Internal.imul(this.value, Tools.castIfNeeded(DSL.power(DSL.two(), this.count), this.value)));
                break;
            }
            default: {
                ctx.sql('(').visit(this.value).sql(" << ").visit(this.count).sql(')');
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.count;
    }

    @Override
    public final QOM.Shl<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<Number>)this.$arg2());
    }

    @Override
    public final QOM.Shl<T> $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<? extends Number>, ? extends QOM.Shl<T>> $constructor() {
        return (a1, a2) -> new Shl(a1, (Field<? extends Number>)((Field<Number>)a2));
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Shl) {
            QOM.Shl o = (QOM.Shl)that;
            return Objects.equals(this.$value(), o.$value()) && Objects.equals(this.$count(), o.$count());
        }
        return super.equals(that);
    }
}

