/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class Space
extends AbstractField<String>
implements QOM.Space {
    final Field<? extends Number> count;

    Space(Field<? extends Number> count) {
        super(Names.N_SPACE, Tools.allNotNull(SQLDataType.VARCHAR, count));
        this.count = Tools.nullSafeNotNull(count, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: 
            case TRINO: {
                return false;
            }
            case DERBY: 
            case DUCKDB: 
            case HSQLDB: 
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: 
            case TRINO: {
                ctx.visit(DSL.rpad(DSL.inline(' '), this.count));
                break;
            }
            case DERBY: 
            case DUCKDB: 
            case HSQLDB: 
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(DSL.repeat(DSL.inline(" "), this.count));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SPACE, this.getDataType(), this.count));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.count;
    }

    @Override
    public final QOM.Space $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.Space> $constructor() {
        return a1 -> new Space((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Space) {
            QOM.Space o = (QOM.Space)that;
            return Objects.equals(this.$count(), o.$count());
        }
        return super.equals(that);
    }
}

