/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.placeholders;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionEntry;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.database.model.user.UserReport;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.placeholders.Priority;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderReceiver
extends PlaceholderExpansion {
    private static final Map<CompetitionType, ConfigMessage> COMPETITION_TYPE_MESSAGES = Map.of(CompetitionType.LARGEST_FISH, ConfigMessage.COMPETITION_TYPE_LARGEST, CompetitionType.LARGEST_TOTAL, ConfigMessage.COMPETITION_TYPE_LARGEST_TOTAL, CompetitionType.MOST_FISH, ConfigMessage.COMPETITION_TYPE_MOST, CompetitionType.SPECIFIC_FISH, ConfigMessage.COMPETITION_TYPE_SPECIFIC, CompetitionType.SPECIFIC_RARITY, ConfigMessage.COMPETITION_TYPE_SPECIFIC_RARITY, CompetitionType.SHORTEST_FISH, ConfigMessage.COMPETITION_TYPE_SHORTEST, CompetitionType.SHORTEST_TOTAL, ConfigMessage.COMPETITION_TYPE_SHORTEST_TOTAL);
    private final EvenMoreFish plugin;
    private final List<HandlerDefinition> handlers;

    public PlaceholderReceiver(EvenMoreFish plugin) {
        this.plugin = plugin;
        this.handlers = this.createHandlers();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getPluginMeta().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "emf";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    private List<HandlerDefinition> createHandlers() {
        return Stream.of(new HandlerDefinition(id -> id.startsWith("competition_place_size_"), Priority.SPECIFIC_PATTERN, this::handleCompetitionPlaceSize), new HandlerDefinition(id -> id.startsWith("competition_place_fish_"), Priority.SPECIFIC_PATTERN, this::handleCompetitionPlaceFish), new HandlerDefinition(id -> id.startsWith("competition_place_player_"), Priority.SPECIFIC_PATTERN, this::handleCompetitionPlacePlayer), new HandlerDefinition(id -> id.startsWith("total_money_earned_"), Priority.GENERAL_PATTERN, this::handleTotalMoneyEarned), new HandlerDefinition(id -> id.startsWith("total_fish_sold_"), Priority.GENERAL_PATTERN, this::handleTotalFishSold), new HandlerDefinition(id -> id.equalsIgnoreCase("competition_time_left"), Priority.EXACT_MATCH, this::handleCompetitionTimeLeft), new HandlerDefinition(id -> id.equalsIgnoreCase("competition_active"), Priority.EXACT_MATCH, this::handleCompetitionActive), new HandlerDefinition(id -> id.equalsIgnoreCase("custom_fishing_boolean"), Priority.EXACT_MATCH, this::handleCustomFishingBoolean), new HandlerDefinition(id -> id.equalsIgnoreCase("custom_fishing_status"), Priority.EXACT_MATCH, this::handleCustomFishingStatus), new HandlerDefinition(id -> id.equalsIgnoreCase("competition_type"), Priority.EXACT_MATCH, this::handleCompetitionType), new HandlerDefinition(id -> id.equalsIgnoreCase("competition_type_format"), Priority.EXACT_MATCH, this::handleCompetitionTypeFormat)).sorted(Comparator.comparingInt(def -> def.priority().ordinal())).toList();
    }

    private String handleCompetitionPlacePlayer(Player player, String identifier) {
        Competition activeComp = Competition.getCurrentlyActive();
        if (activeComp == null) {
            return ConfigMessage.PLACEHOLDER_NO_COMPETITION_RUNNING.getMessage().getLegacyMessage();
        }
        int place = this.parsePlace(identifier, "competition_place_player_".length());
        if (!this.leaderboardContainsPlace(activeComp, place)) {
            return ConfigMessage.PLACEHOLDER_NO_PLAYER_IN_PLACE.getMessage().getLegacyMessage();
        }
        CompetitionEntry entry = activeComp.getLeaderboard().getEntry(place);
        if (entry == null) {
            return "";
        }
        UUID uuid = entry.getPlayer();
        if (uuid != null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            return offlinePlayer.getName();
        }
        return "";
    }

    @NotNull
    private String handleCompetitionTypeFormat(Player player, String identifier) {
        Competition activeComp = Competition.getCurrentlyActive();
        if (activeComp == null) {
            return "";
        }
        ConfigMessage message = COMPETITION_TYPE_MESSAGES.get((Object)activeComp.getCompetitionType());
        if (message == null) {
            return "";
        }
        EMFMessage typeFormat = activeComp.getCompetitionType().getStrategy().getTypeFormat(activeComp, message);
        return typeFormat.getLegacyMessage();
    }

    private String handleCompetitionType(Player player, String identifier) {
        Competition activeComp = Competition.getCurrentlyActive();
        return activeComp != null ? activeComp.getCompetitionType().name() : ConfigMessage.PLACEHOLDER_NO_COMPETITION_RUNNING.getMessage().getLegacyMessage();
    }

    private String handleCompetitionPlaceSize(Player player, String identifier) {
        Competition activeComp = Competition.getCurrentlyActive();
        if (activeComp == null) {
            return ConfigMessage.PLACEHOLDER_NO_COMPETITION_RUNNING_SIZE.getMessage().getLegacyMessage();
        }
        if (!activeComp.getCompetitionType().getStrategy().shouldUseFishLength()) {
            return ConfigMessage.PLACEHOLDER_SIZE_DURING_MOST_FISH.getMessage().getLegacyMessage();
        }
        int place = this.parsePlace(identifier, "competition_place_size_".length());
        if (!this.leaderboardContainsPlace(activeComp, place)) {
            return ConfigMessage.PLACEHOLDER_NO_SIZE_IN_PLACE.getMessage().getLegacyMessage();
        }
        CompetitionEntry entry = activeComp.getLeaderboard().getEntry(place);
        if (entry == null) {
            return "";
        }
        float value = entry.getValue();
        return value != -1.0f ? Double.toString(FishUtils.roundDouble(value, 1)) : "";
    }

    private String handleCompetitionPlaceFish(Player player, String identifier) {
        Competition activeComp = Competition.getCurrentlyActive();
        if (activeComp == null) {
            return ConfigMessage.PLACEHOLDER_NO_COMPETITION_RUNNING_FISH.getMessage().getLegacyMessage();
        }
        int place = this.parsePlace(identifier, "competition_place_fish_".length());
        CompetitionEntry entry = activeComp.getLeaderboard().getEntry(place);
        if (entry == null) {
            return "";
        }
        if (activeComp.getCompetitionType() == CompetitionType.LARGEST_FISH) {
            if (!this.leaderboardContainsPlace(activeComp, place)) {
                return ConfigMessage.PLACEHOLDER_NO_FISH_IN_PLACE.getMessage().getLegacyMessage();
            }
            Fish fish = entry.getFish();
            if (fish != null) {
                return this.formatFishMessage(fish);
            }
        } else {
            float value = entry.getValue();
            if (value != -1.0f) {
                return this.formatMostFishMessage((int)value);
            }
            return ConfigMessage.PLACEHOLDER_NO_FISH_IN_PLACE.getMessage().getLegacyMessage();
        }
        return "";
    }

    @Nullable
    private String handleTotalMoneyEarned(Player player, @NotNull String identifier) {
        String substring = identifier.substring("total_money_earned_".length());
        if (substring.equalsIgnoreCase("player")) {
            if (player == null) {
                return null;
            }
            UserReport userReport = this.plugin.getPluginDataManager().getUserReportDataManager().get(player.getUniqueId().toString());
            return userReport != null ? String.format("%.2f", userReport.getMoneyEarned()) : null;
        }
        try {
            UUID uuid = UUID.fromString(substring);
            UserReport userReport = this.plugin.getPluginDataManager().getUserReportDataManager().get(uuid.toString());
            return userReport != null ? String.format("%.2f", userReport.getMoneyEarned()) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private String handleTotalFishSold(Player player, @NotNull String identifier) {
        String substring = identifier.substring("total_fish_sold_".length());
        if (substring.equalsIgnoreCase("player")) {
            if (player == null) {
                return null;
            }
            UserReport userReport = this.plugin.getPluginDataManager().getUserReportDataManager().get(player.getUniqueId().toString());
            return userReport != null ? String.valueOf(userReport.getFishSold()) : null;
        }
        try {
            UUID uuid = UUID.fromString(substring);
            UserReport userReport = this.plugin.getPluginDataManager().getUserReportDataManager().get(uuid.toString());
            return userReport != null ? String.valueOf(userReport.getFishSold()) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @NotNull
    private String handleCompetitionTimeLeft(Player player, String identifier) {
        return Competition.getNextCompetitionMessage().getLegacyMessage();
    }

    @NotNull
    private String handleCompetitionActive(Player player, String identifier) {
        return Boolean.toString(Competition.isActive());
    }

    @NotNull
    private String handleCustomFishingBoolean(Player player, String identifier) {
        return Boolean.toString(!this.plugin.isCustomFishingDisabled(player));
    }

    @NotNull
    private String handleCustomFishingStatus(Player player, String identifier) {
        return this.plugin.isCustomFishingDisabled(player) ? ConfigMessage.CUSTOM_FISHING_DISABLED.getMessage().getLegacyMessage() : ConfigMessage.CUSTOM_FISHING_ENABLED.getMessage().getLegacyMessage();
    }

    private int parsePlace(String identifier, int prefixLength) {
        try {
            return Integer.parseInt(identifier.substring(prefixLength));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    private String formatFishMessage(@NotNull Fish fish) {
        EMFMessage message = fish.getLength() == -1.0f ? ConfigMessage.PLACEHOLDER_FISH_LENGTHLESS_FORMAT.getMessage() : ConfigMessage.PLACEHOLDER_FISH_FORMAT.getMessage();
        message.setLength(Float.toString(fish.getLength()));
        message.setFishCaught(fish.getDisplayName());
        message.setRarity(fish.getRarity().getDisplayName());
        return message.getLegacyMessage();
    }

    @NotNull
    private String formatMostFishMessage(int amount) {
        EMFMessage message = ConfigMessage.PLACEHOLDER_FISH_MOST_FORMAT.getMessage();
        message.setAmount(amount);
        return message.getLegacyMessage();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        for (HandlerDefinition def : this.handlers) {
            if (!def.matcher().test(identifier)) continue;
            return def.handler().apply(player, identifier);
        }
        return null;
    }

    private boolean leaderboardContainsPlace(@NotNull Competition competition, int place) {
        return place > 0 && competition.getLeaderboardSize() >= place;
    }

    private record HandlerDefinition(Predicate<String> matcher, Priority priority, BiFunction<Player, String, String> handler) {
    }
}

