/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.plugin;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.GuiConfig;
import com.oheers.fish.config.GuiFillerConfig;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.config.MessageConfig;
import com.oheers.fish.libs.messagelib.ObjectProcessor;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class ConfigurationManager {
    private final EvenMoreFish plugin;

    public ConfigurationManager(EvenMoreFish plugin) {
        this.plugin = plugin;
    }

    public void loadConfigurations() {
        try {
            this.prepareMessageLib();
            new MainConfig();
            new MessageConfig();
            new GuiConfig();
            new GuiFillerConfig();
            this.plugin.getLogger().info("Successfully loaded all configurations");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load configurations", e);
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    public void reloadConfigurations() {
        try {
            this.plugin.reloadConfig();
            this.plugin.saveDefaultConfig();
            MainConfig.getInstance().reload();
            MessageConfig.getInstance().reload();
            GuiConfig.getInstance().reload();
            GuiFillerConfig.getInstance().reload();
            this.plugin.getLogger().info("Successfully reloaded all configurations");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to reload configurations", e);
        }
    }

    private void prepareMessageLib() {
        ObjectProcessor.registerProcessor(EMFSingleMessage.class, EMFMessage::getComponentListMessage);
        ObjectProcessor.registerProcessor(EMFListMessage.class, EMFMessage::getComponentListMessage);
    }
}

