/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.plugin;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.Database;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.data.FishLogKey;
import com.oheers.fish.database.data.FishRarityKey;
import com.oheers.fish.database.data.UserFishRarityKey;
import com.oheers.fish.database.data.manager.DataManager;
import com.oheers.fish.database.data.manager.UserManager;
import com.oheers.fish.database.data.strategy.impl.CompetitionSavingStrategy;
import com.oheers.fish.database.data.strategy.impl.FishLogSavingStrategy;
import com.oheers.fish.database.data.strategy.impl.FishStatsSavingStrategy;
import com.oheers.fish.database.data.strategy.impl.UserFishStatsSavingStrategy;
import com.oheers.fish.database.data.strategy.impl.UserReportsSavingStrategy;
import com.oheers.fish.database.model.CompetitionReport;
import com.oheers.fish.database.model.fish.FishLog;
import com.oheers.fish.database.model.fish.FishStats;
import com.oheers.fish.database.model.user.UserFishStats;
import com.oheers.fish.database.model.user.UserReport;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;

public class PluginDataManager {
    private final EvenMoreFish plugin;
    private Database database;
    private UserManager userManager;
    private DataManager<Collection<FishLog>> fishLogDataManager;
    private DataManager<FishStats> fishStatsDataManager;
    private DataManager<UserFishStats> userFishStatsDataManager;
    private DataManager<UserReport> userReportDataManager;
    private DataManager<CompetitionReport> competitionDataManager;

    public PluginDataManager(EvenMoreFish plugin) {
        this.plugin = plugin;
        this.init();
    }

    public void init() {
        if (!MainConfig.getInstance().databaseEnabled()) {
            this.plugin.getLogger().info("Database is disabled in config");
            return;
        }
        this.database = new Database();
        this.initDataManagers();
    }

    public void initDataManagers() {
        this.userManager = new UserManager(this.database);
        this.fishLogDataManager = new DataManager<Collection>(new FishLogSavingStrategy(), key -> {
            FishLogKey logKey = FishLogKey.from(key);
            return Collections.singleton(this.database.getFishLog(logKey.getUserId(), logKey.getFishName(), logKey.getFishRarity(), logKey.getDateTime()));
        });
        this.fishStatsDataManager = new DataManager<FishStats>(new FishStatsSavingStrategy(), key -> {
            FishRarityKey fishRarityKey = FishRarityKey.from(key);
            return this.database.getFishStats(fishRarityKey.getFishName(), fishRarityKey.getFishRarity());
        });
        this.userFishStatsDataManager = new DataManager<UserFishStats>(new UserFishStatsSavingStrategy(MainConfig.getInstance().getUserFishStatsSaveInterval()), key -> {
            UserFishRarityKey userFishRarityKey = UserFishRarityKey.from(key);
            return this.database.getUserFishStats(userFishRarityKey.getUserId(), userFishRarityKey.getFishName(), userFishRarityKey.getFishRarity());
        });
        this.userReportDataManager = new DataManager<UserReport>(new UserReportsSavingStrategy(), uuid -> this.database.getUserReport(UUID.fromString(uuid)));
        this.competitionDataManager = new DataManager<CompetitionReport>(new CompetitionSavingStrategy(MainConfig.getInstance().getCompetitionSaveInterval()), key -> this.database.getCompetitionReport(Integer.parseInt(key)));
    }

    public void shutdown() {
        if (this.database == null || !DatabaseUtil.isDatabaseOnline()) {
            return;
        }
        try {
            this.userReportDataManager.flush();
            this.userFishStatsDataManager.flush();
            this.fishStatsDataManager.flush();
            this.competitionDataManager.flush();
            this.database.shutdown();
            this.plugin.getLogger().info("Database connections closed successfully");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error while shutting down database", e);
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public DataManager<Collection<FishLog>> getFishLogDataManager() {
        return this.fishLogDataManager;
    }

    public DataManager<FishStats> getFishStatsDataManager() {
        return this.fishStatsDataManager;
    }

    public DataManager<UserFishStats> getUserFishStatsDataManager() {
        return this.userFishStatsDataManager;
    }

    public DataManager<UserReport> getUserReportDataManager() {
        return this.userReportDataManager;
    }

    public DataManager<CompetitionReport> getCompetitionDataManager() {
        return this.competitionDataManager;
    }

    public Database getDatabase() {
        return this.database;
    }
}

