/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.recipe;

import com.oheers.fish.FishUtils;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.recipe.EMFRecipe;
import com.oheers.fish.recipe.RecipeUtil;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class EMFShapedRecipe
extends EMFRecipe<ShapedRecipe> {
    private final List<String> rawShape;
    private final Section ingredientsSection;
    private final NamespacedKey key;
    private final ItemStack result;

    public EMFShapedRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull Section section) {
        this.rawShape = section.getStringList("shape");
        this.ingredientsSection = section.getSection("ingredients");
        if (this.rawShape.isEmpty() || this.ingredientsSection == null) {
            throw new RuntimeException("Shaped recipe is missing shape or ingredients.");
        }
        this.key = key;
        this.result = result;
    }

    @Override
    @NotNull
    protected ShapedRecipe prepareRecipe() {
        ShapedRecipe recipe = new ShapedRecipe(this.key, this.result);
        String[] shape = (String[])this.rawShape.stream().limit(3L).toArray(String[]::new);
        recipe.shape(shape);
        this.ingredientsSection.getRoutesAsStrings(false).forEach(key -> {
            char character = FishUtils.getCharFromString(key, '#');
            String materialStr = this.ingredientsSection.getString((String)key);
            if (materialStr == null) {
                return;
            }
            RecipeChoice choice = RecipeUtil.getRecipeChoice(materialStr);
            if (choice == null) {
                return;
            }
            recipe.setIngredient(character, choice);
        });
        return recipe;
    }
}

