/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.recipe;

import com.oheers.fish.FishUtils;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.recipe.EMFRecipe;
import com.oheers.fish.recipe.EMFShapedRecipe;
import com.oheers.fish.recipe.EMFShapelessRecipe;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeUtil {
    @Nullable
    public static RecipeChoice getRecipeChoice(String materialStr) {
        ItemStack customItem = FishUtils.getItem(materialStr);
        if (customItem == null || customItem.getType().isAir()) {
            return null;
        }
        return new RecipeChoice.ExactChoice(customItem);
    }

    @Nullable
    public static EMFRecipe<?> getRecipe(@NotNull Section section, @NotNull NamespacedKey key, @NotNull ItemStack result) {
        String type = section.getString("type");
        if (type == null) {
            return null;
        }
        return switch (type.toLowerCase()) {
            case "shapeless" -> {
                List<String> ingredients = section.getStringList("ingredients");
                yield new EMFShapelessRecipe(key, result, ingredients);
            }
            case "shaped" -> new EMFShapedRecipe(key, result, section);
            default -> null;
        };
    }
}

