/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.selling;

import com.oheers.fish.FishUtils;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.utils.nbt.NbtKeys;
import com.oheers.fish.utils.nbt.NbtUtils;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.iface.ReadWriteNBT;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class WorthNBT {
    private WorthNBT() {
        throw new UnsupportedOperationException();
    }

    public static ItemStack setNBT(@NotNull ItemStack fishItem, @NotNull Fish fish) {
        if (NbtUtils.isInvalidItem(fishItem)) {
            return fishItem;
        }
        NBT.modify(fishItem, nbt -> {
            ReadWriteNBT emfCompound = nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND);
            if (fish.getLength() > 0.0f) {
                emfCompound.setFloat("emf-fish-length", Float.valueOf(fish.getLength()));
            }
            if (!fish.hasFishermanDisabled() && fish.getFisherman() != null) {
                emfCompound.setString("emf-fish-player", fish.getFisherman().toString());
            }
            emfCompound.setString("emf-fish-name", fish.getName());
            emfCompound.setString("emf-fish-rarity", fish.getRarity().getId());
            emfCompound.setInteger("emf-fish-random-index", fish.getFactory().getRandomIndex());
        });
        return fishItem;
    }

    public static void setNBT(Skull fishSkull, Fish fish) {
        NamespacedKey nbtlength = NbtUtils.getNamespacedKey("emf-fish-length");
        NamespacedKey nbtplayer = NbtUtils.getNamespacedKey("emf-fish-player");
        NamespacedKey nbtrarity = NbtUtils.getNamespacedKey("emf-fish-rarity");
        NamespacedKey nbtname = NbtUtils.getNamespacedKey("emf-fish-name");
        NamespacedKey nbtrandomIndex = NbtUtils.getNamespacedKey("emf-fish-random-index");
        PersistentDataContainer itemMeta = fishSkull.getPersistentDataContainer();
        if (fish.getLength() > 0.0f) {
            itemMeta.set(nbtlength, PersistentDataType.FLOAT, (Object)Float.valueOf(fish.getLength()));
        }
        if (fish.getFisherman() != null && !fish.hasFishermanDisabled()) {
            itemMeta.set(nbtplayer, PersistentDataType.STRING, (Object)fish.getFisherman().toString());
        }
        itemMeta.set(nbtrandomIndex, PersistentDataType.INTEGER, (Object)fish.getFactory().getRandomIndex());
        itemMeta.set(nbtrarity, PersistentDataType.STRING, (Object)fish.getRarity().getId());
        itemMeta.set(nbtname, PersistentDataType.STRING, (Object)fish.getName());
    }

    public static double getValue(@NotNull ItemStack item) {
        if (NbtUtils.isInvalidItem(item)) {
            return -1.0;
        }
        if (!FishUtils.isFish(item)) {
            return -1.0;
        }
        Float length = NbtUtils.getFloat(item, "emf-fish-length");
        String rarityStr = NbtUtils.getString(item, "emf-fish-rarity");
        String name = NbtUtils.getString(item, "emf-fish-name");
        try {
            Rarity rarity = FishManager.getInstance().getRarity(rarityStr);
            Fish fish = rarity.getFish(name);
            double value = fish.getSetWorth();
            if (value == 0.0) {
                throw new NullPointerException();
            }
            return value;
        }
        catch (NullPointerException npe) {
            return length != null && length.floatValue() > 0.0f ? WorthNBT.getMultipliedValue(length, rarityStr, name) : 0.0;
        }
    }

    private static double getMultipliedValue(Float length, String rarity, String name) {
        return WorthNBT.getWorthMultiplier(rarity, name) * (double)length.floatValue();
    }

    private static double getWorthMultiplier(String rarityStr, String name) {
        Rarity rarity = FishManager.getInstance().getRarity(rarityStr);
        if (rarity == null) {
            return 0.0;
        }
        Fish fish = rarity.getFish(name);
        if (fish == null) {
            return 0.0;
        }
        double value = fish.getWorthMultiplier();
        if (value == 0.0) {
            return rarity.getWorthMultiplier();
        }
        return value;
    }
}

