/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.update;

import com.oheers.fish.EvenMoreFish;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class UpdateChecker {
    private final EvenMoreFish plugin;

    public UpdateChecker(EvenMoreFish plugin) {
        this.plugin = plugin;
    }

    public String getVersion() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.modrinth.com/v2/project/vlh7rLCf/version")).header("User-Agent", "EvenMoreFish/" + this.plugin.getPluginMeta().getVersion()).timeout(Duration.ofSeconds(10L)).GET().build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("HTTP " + response.statusCode());
            }
            JSONArray versions = (JSONArray)new JSONParser().parse(response.body());
            if (versions.isEmpty()) {
                return this.plugin.getPluginMeta().getVersion();
            }
            JSONObject latestVersion = (JSONObject)versions.get(0);
            return latestVersion.get((Object)"version_number").toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Update check failed: " + e.getMessage());
            this.plugin.getLogger().info("Manual update check: https://modrinth.com/plugin/evenmorefish/versions");
            return this.plugin.getPluginMeta().getVersion();
        }
    }

    @Contract(value=" -> new")
    @NotNull
    public CompletableFuture<Boolean> checkUpdate() {
        return CompletableFuture.supplyAsync(() -> {
            ComparableVersion serverVersion;
            ComparableVersion modrinthVersion = new ComparableVersion(new UpdateChecker(this.plugin).getVersion());
            return modrinthVersion.compareTo(serverVersion = new ComparableVersion(this.plugin.getPluginMeta().getVersion())) > 0;
        });
    }
}

