/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.utils;

import com.oheers.fish.FishUtils;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.events.FishEatEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class ItemProtectionListener
implements Listener {
    @EventHandler
    public void onCraft(CraftItemEvent event) {
        if (!MainConfig.getInstance().blockCrafting()) {
            return;
        }
        for (ItemStack craftItem : event.getInventory().getMatrix()) {
            if (craftItem == null || !FishUtils.isFish(craftItem) && !FishUtils.isBaitObject(craftItem)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onConsume(PlayerItemConsumeEvent event) {
        if (FishEatEvent.getInstance().checkEatEvent(event) || !MainConfig.getInstance().blockConsume()) {
            return;
        }
        ItemStack item = event.getItem();
        if (FishUtils.isFish(item) || FishUtils.isBaitObject(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        if (!MainConfig.getInstance().blockFurnaceBurn()) {
            return;
        }
        ItemStack item = event.getFuel();
        if (FishUtils.isFish(item) || FishUtils.isBaitObject(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCook(BlockCookEvent event) {
        if (!MainConfig.getInstance().blockCooking()) {
            return;
        }
        ItemStack item = event.getSource();
        if (FishUtils.isFish(item) || FishUtils.isBaitObject(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (!MainConfig.getInstance().blockPlacing()) {
            return;
        }
        ItemStack item = event.getItemInHand();
        if (FishUtils.isFish(item) || FishUtils.isBaitObject(item)) {
            event.setCancelled(true);
        }
    }
}

