/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.utils;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.ToDoubleFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WeightedRandom {
    private WeightedRandom() {
        throw new UnsupportedOperationException();
    }

    public static <T> T pick(List<T> elements, ToDoubleFunction<T> weightFunction, Random random) {
        return WeightedRandom.pick(elements, weightFunction, 1.0, Collections.emptySet(), random);
    }

    @Nullable
    public static <T> T pick(@NotNull List<T> elements, ToDoubleFunction<T> weightFunction, double boostRate, Set<T> boosted, Random random) {
        if (elements.isEmpty()) {
            return null;
        }
        Random rng = random != null ? random : ThreadLocalRandom.current();
        double totalWeight = WeightedRandom.calcTotalWeight(elements, weightFunction, boostRate, boosted);
        if (totalWeight <= 0.0) {
            return elements.get(rng.nextInt(elements.size()));
        }
        double r = rng.nextDouble() * totalWeight;
        for (T element : elements) {
            double weight = WeightedRandom.getEffectiveWeight(element, weightFunction, boostRate, boosted);
            if (!((r -= weight) <= 0.0)) continue;
            return element;
        }
        return elements.get(elements.size() - 1);
    }

    private static <T> double calcTotalWeight(@NotNull List<T> elements, ToDoubleFunction<T> weightFunction, double boostRate, Set<T> boosted) {
        double total = 0.0;
        for (T element : elements) {
            total += WeightedRandom.getEffectiveWeight(element, weightFunction, boostRate, boosted);
        }
        return total;
    }

    private static <T> double getEffectiveWeight(T element, @NotNull ToDoubleFunction<T> weightFunction, double boostRate, Set<T> boosted) {
        double baseWeight = weightFunction.applyAsDouble(element);
        if (baseWeight <= 0.0) {
            return 0.0;
        }
        return boostRate != -1.0 && boosted.contains(element) ? baseWeight * boostRate : baseWeight;
    }
}

