/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.utils.nbt;

import com.oheers.fish.utils.nbt.NbtVersion;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.iface.ReadableItemNBT;
import com.oheers.fish.utils.nbtapi.iface.ReadableNBT;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtUtils {
    private NbtUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isInvalidItem(@Nullable ItemStack item) {
        return item == null || item.isEmpty();
    }

    public static boolean hasKey(ItemStack item, String key) {
        NbtVersion nbtVersion = NbtVersion.getVersion(item);
        NamespacedKey namespacedKey = NbtUtils.getNamespacedKey(key);
        return NBT.get(item, nbt -> NbtUtils.hasKey(nbtVersion, namespacedKey, nbt));
    }

    public static boolean hasKey(BlockState skull, String key) {
        NbtVersion nbtVersion = NbtVersion.getVersion(skull);
        NamespacedKey namespacedKey = NbtUtils.getNamespacedKey(key);
        return NBT.get(skull, nbt -> NbtUtils.hasKey(nbtVersion, namespacedKey, nbt));
    }

    private static boolean hasKey(@NotNull NbtVersion nbtVersion, NamespacedKey namespacedKey, ReadableNBT nbt) {
        return switch (nbtVersion) {
            default -> throw new MatchException(null, null);
            case NbtVersion.NBTAPI -> nbt.hasTag(namespacedKey.toString());
            case NbtVersion.LEGACY -> {
                if (nbt.hasTag("PublicBukkitValues")) {
                    ReadableNBT compound = nbt.getCompound("PublicBukkitValues");
                    if (compound == null) {
                        yield false;
                    }
                    yield compound.hasTag(namespacedKey.toString());
                }
                yield false;
            }
            case NbtVersion.COMPAT -> {
                ReadableNBT compound = nbt.getCompound(namespacedKey.getNamespace());
                if (compound == null) {
                    yield false;
                }
                yield compound.hasTag(namespacedKey.getKey());
            }
        };
    }

    @Nullable
    private static String getNbtString(NamespacedKey namespacedKey, @NotNull NbtVersion nbtVersion, ReadableItemNBT nbt) {
        return switch (nbtVersion) {
            default -> throw new MatchException(null, null);
            case NbtVersion.NBTAPI -> {
                if (nbt.hasTag(namespacedKey.toString())) {
                    yield nbt.getString(namespacedKey.toString());
                }
                yield null;
            }
            case NbtVersion.COMPAT -> {
                ReadableNBT compound = nbt.getCompound(namespacedKey.getNamespace());
                if (compound == null) {
                    yield null;
                }
                yield compound.getString(namespacedKey.getKey());
            }
            case NbtVersion.LEGACY -> {
                if (nbt.hasTag("PublicBukkitValues")) {
                    ReadableNBT publicBukkitValues = nbt.getCompound("PublicBukkitValues");
                    if (publicBukkitValues == null) {
                        yield null;
                    }
                    String baitString = publicBukkitValues.getString(namespacedKey.toString());
                    if (baitString == null) {
                        yield null;
                    }
                    if (baitString.isEmpty()) {
                        yield null;
                    }
                    yield baitString;
                }
                yield null;
            }
        };
    }

    @Nullable
    public static String getString(ItemStack item, String key) {
        if (NbtUtils.isInvalidItem(item)) {
            return null;
        }
        NbtVersion nbtVersion = NbtVersion.getVersion(item);
        NamespacedKey namespacedKey = NbtUtils.getNamespacedKey(key);
        return NBT.get(item, nbt -> NbtUtils.getNbtString(namespacedKey, nbtVersion, nbt));
    }

    public static String[] getBaitArray(ItemStack item) {
        if (NbtUtils.isInvalidItem(item)) {
            return new String[0];
        }
        String appliedBait = NbtUtils.getString(item, "emf-applied-bait");
        if (appliedBait == null) {
            return new String[0];
        }
        return appliedBait.split(",");
    }

    @Nullable
    public static Float getFloat(ItemStack item, String key) {
        if (NbtUtils.isInvalidItem(item)) {
            return null;
        }
        NbtVersion nbtVersion = NbtVersion.getVersion(item);
        NamespacedKey namespacedKey = NbtUtils.getNamespacedKey(key);
        return NBT.get(item, nbt -> switch (nbtVersion) {
            default -> throw new MatchException(null, null);
            case NbtVersion.NBTAPI -> {
                if (nbt.hasTag(namespacedKey.toString())) {
                    yield nbt.getFloat(namespacedKey.toString());
                }
                yield null;
            }
            case NbtVersion.COMPAT -> {
                ReadableNBT compound = nbt.getCompound(namespacedKey.getNamespace());
                if (compound == null) {
                    yield null;
                }
                yield compound.getFloat(namespacedKey.getKey());
            }
            case NbtVersion.LEGACY -> {
                ReadableNBT compound = nbt.getCompound("PublicBukkitValues");
                if (compound == null) {
                    yield null;
                }
                yield compound.getFloat(namespacedKey.toString());
            }
        });
    }

    @Nullable
    public static Integer getInteger(ItemStack item, String key) {
        if (NbtUtils.isInvalidItem(item)) {
            return null;
        }
        NbtVersion nbtVersion = NbtVersion.getVersion(item);
        NamespacedKey namespacedKey = NbtUtils.getNamespacedKey(key);
        return NBT.get(item, nbt -> switch (nbtVersion) {
            default -> throw new MatchException(null, null);
            case NbtVersion.NBTAPI -> {
                if (nbt.hasTag(namespacedKey.toString())) {
                    yield nbt.getInteger(namespacedKey.toString());
                }
                yield null;
            }
            case NbtVersion.COMPAT -> {
                ReadableNBT compound = nbt.getCompound(namespacedKey.getNamespace());
                if (compound == null) {
                    yield null;
                }
                yield compound.getInteger(namespacedKey.getKey());
            }
            case NbtVersion.LEGACY -> {
                ReadableNBT compound = nbt.getCompound("PublicBukkitValues");
                if (compound == null) {
                    yield null;
                }
                yield compound.getInteger(namespacedKey.toString());
            }
        });
    }

    @Contract(value="_ -> new")
    @NotNull
    public static NamespacedKey getNamespacedKey(String key) {
        return new NamespacedKey((Plugin)JavaPlugin.getProvidingPlugin(NbtUtils.class), key);
    }
}

