/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.competition.Bar;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.messages.ConfigMessage;
import net.kyori.adventure.audience.Audience;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Toggle {
    private final EvenMoreFish plugin;
    private final NamespacedKey fishToggleKey;
    private final NamespacedKey bossBarToggleKey;

    public Toggle(@NotNull EvenMoreFish plugin) {
        this.plugin = plugin;
        this.fishToggleKey = new NamespacedKey((Plugin)plugin, "fish-disabled");
        this.bossBarToggleKey = new NamespacedKey((Plugin)plugin, "bossbar-disabled");
    }

    public void performFishToggle(@NotNull Player player) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        if (this.isCustomFishingDisabled(player)) {
            pdc.set(this.fishToggleKey, PersistentDataType.BOOLEAN, (Object)false);
            ConfigMessage.TOGGLE_FISHING_ON.getMessage().send((Audience)player);
        } else {
            pdc.set(this.fishToggleKey, PersistentDataType.BOOLEAN, (Object)true);
            ConfigMessage.TOGGLE_FISHING_OFF.getMessage().send((Audience)player);
        }
    }

    public boolean isCustomFishingDisabled(@NotNull Player player) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        return (Boolean)pdc.getOrDefault(this.fishToggleKey, PersistentDataType.BOOLEAN, (Object)false);
    }

    public void performBossBarToggle(@NotNull Player player) {
        Bar activeBar;
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        Competition activeComp = Competition.getCurrentlyActive();
        Bar bar = activeBar = activeComp == null ? null : activeComp.getStatusBar();
        if (this.isBossBarDisabled(player)) {
            pdc.set(this.bossBarToggleKey, PersistentDataType.BOOLEAN, (Object)false);
            ConfigMessage.TOGGLE_BOSSBAR_ON.getMessage().send((Audience)player);
            if (activeBar != null) {
                activeBar.addPlayer(player);
            }
        } else {
            pdc.set(this.bossBarToggleKey, PersistentDataType.BOOLEAN, (Object)true);
            ConfigMessage.TOGGLE_BOSSBAR_OFF.getMessage().send((Audience)player);
            if (activeBar != null) {
                activeBar.removePlayer(player);
            }
        }
    }

    public boolean isBossBarDisabled(@NotNull Player player) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        return (Boolean)pdc.getOrDefault(this.bossBarToggleKey, PersistentDataType.BOOLEAN, (Object)false);
    }
}

