/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.addons.internal.requirement.Phase;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import java.util.List;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MoonPhaseRequirementType
extends RequirementType {
    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        World world = context.getWorld();
        if (world == null) {
            return false;
        }
        int phaseId = (int)(world.getFullTime() / 24000L) % 8;
        for (String value : values) {
            Phase phase;
            try {
                phase = Phase.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                EvenMoreFish.getInstance().getLogger().severe(value + " is not a valid moon phase.");
                return false;
            }
            if (phase.getPhaseID() != phaseId) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "MOON-PHASE";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

