/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.reward;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.reward.RewardType;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class HealthRewardType
extends RewardType {
    @Override
    public void doReward(@NotNull Player player, @NotNull String key, @NotNull String value, Location hookLocation) {
        double rewardHealth;
        try {
            rewardHealth = Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            EvenMoreFish.getInstance().getLogger().warning("Invalid number specified for RewardType " + this.getIdentifier() + ": " + value);
            return;
        }
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        double maxHealth = attribute == null ? 20.0 : attribute.getValue();
        double finalHealth = player.getHealth() + rewardHealth;
        if (finalHealth > maxHealth) {
            player.setHealth(maxHealth);
        } else if (finalHealth < 0.0) {
            player.setHealth(0.0);
        } else {
            player.setHealth(finalHealth);
        }
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "HEALTH";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

