/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.addons;

import com.oheers.fish.api.addons.ItemAddon;
import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.api.registry.EMFRegistry;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAddonRegistry
implements EMFRegistry<ItemAddon> {
    private static final ItemAddonRegistry instance = new ItemAddonRegistry();
    private final Map<String, ItemAddon> registry = new TreeMap<String, ItemAddon>(String.CASE_INSENSITIVE_ORDER);

    private ItemAddonRegistry() {
    }

    @NotNull
    public static ItemAddonRegistry getInstance() {
        return instance;
    }

    @Override
    @NotNull
    public Map<String, ItemAddon> getRegistry() {
        return Map.copyOf(this.registry);
    }

    @Override
    @Nullable
    public ItemAddon get(@NotNull String key) {
        return this.registry.get(key);
    }

    @Nullable
    public ItemStack getItem(@NotNull String prefix, @NotNull String id) {
        ItemAddon addon = this.registry.get(prefix);
        if (addon == null) {
            return null;
        }
        return addon.getItemStack(id);
    }

    @Override
    @NotNull
    public ItemAddon getOrDefault(@NotNull String key, @NotNull ItemAddon defaultValue) {
        return this.registry.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean unregister(@NotNull String key) {
        ItemAddon value = this.registry.remove(key);
        if (value == null) {
            return false;
        }
        HandlerList.unregisterAll((Listener)value);
        return true;
    }

    @Override
    public boolean register(@NotNull ItemAddon value, boolean force) {
        if (!value.canLoad()) {
            return false;
        }
        if (!force && this.registry.containsKey(value.getKey())) {
            return false;
        }
        this.registry.put(value.getKey(), value);
        Bukkit.getPluginManager().registerEvents((Listener)value, (Plugin)EMFPlugin.getInstance());
        EMFPlugin.getInstance().debug("Registered " + value.getKey() + " ItemAddon");
        return true;
    }
}

