/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.economy;

import com.oheers.fish.api.economy.EconomyType;
import com.oheers.fish.api.plugin.EMFPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class Economy {
    private final Set<EconomyType> registeredEconomies = new HashSet<EconomyType>();
    private static Economy instance = null;

    private Economy() {
    }

    public static Economy getInstance() {
        if (instance == null) {
            instance = new Economy();
        }
        return instance;
    }

    public List<EconomyType> getRegisteredEconomies() {
        return List.copyOf(this.registeredEconomies);
    }

    public boolean isEnabled() {
        if (this.registeredEconomies.isEmpty()) {
            EMFPlugin.getInstance().getLogger().warning("There are no registered economies.");
            return false;
        }
        return this.registeredEconomies.stream().anyMatch(EconomyType::isAvailable);
    }

    public void deposit(@NotNull OfflinePlayer player, double amount, boolean applyMultiplier) {
        this.registeredEconomies.forEach(type -> type.deposit(player, amount, applyMultiplier));
    }

    public void withdraw(@NotNull OfflinePlayer player, double amount, boolean applyMultiplier) {
        this.registeredEconomies.forEach(type -> type.withdraw(player, amount, applyMultiplier));
    }

    public Map<EconomyType, Double> get(@NotNull OfflinePlayer player) {
        HashMap<EconomyType, Double> valuesMap = new HashMap<EconomyType, Double>();
        this.registeredEconomies.forEach(type -> valuesMap.put((EconomyType)type, type.get(player)));
        return valuesMap;
    }

    @NotNull
    public Optional<EconomyType> getEconomyType(@NotNull String identifier) {
        return this.registeredEconomies.stream().filter(EconomyType::isAvailable).filter(type -> type.getIdentifier().equalsIgnoreCase(identifier)).findFirst();
    }

    @NotNull
    public Component getWorthFormat(double value, boolean applyMultiplier) {
        List<Component> components = this.registeredEconomies.stream().map(type -> type.formatWorth(value, applyMultiplier)).filter(Objects::nonNull).toList();
        return Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), components);
    }

    public boolean registerEconomyType(@NotNull EconomyType economyType) {
        if (this.getEconomyType(economyType.getIdentifier()).isPresent()) {
            return false;
        }
        return this.registeredEconomies.add(economyType);
    }
}

