/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.baits;

import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.items.configs.ItemConfig;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.List;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BaitItemFactory {
    private final String baitId;
    private final List<Rarity> rarities;
    private final List<Fish> fish;
    private final YamlDocument config;

    public BaitItemFactory(String baitId, List<Rarity> rarities, List<Fish> fish, YamlDocument config) {
        this.baitId = baitId;
        this.rarities = rarities;
        this.fish = fish;
        this.config = config;
    }

    public ItemFactory createFactory() {
        ItemFactory factory = ItemFactory.itemFactory((Section)this.config);
        ItemConfig<String> displayNameConfig = factory.getDisplayName();
        displayNameConfig.setEnabled(true);
        displayNameConfig.setDefault("<yellow>" + this.baitId);
        factory.setFinalChanges(item -> {
            item.setAmount(this.config.getInt("drop-quantity", Integer.valueOf(1)).intValue());
            item.editMeta(meta -> meta.lore(this.createBoostLore(factory)));
            BaitNBTManager.applyBaitNBT(item, this.baitId);
        });
        return factory;
    }

    @NotNull
    private List<Component> createBoostLore(ItemFactory factory) {
        EMFListMessage lore = this.getBaseLoreTemplate();
        lore.setVariableWithListInsertion("{boosts}", this.createBoostsVariable());
        lore.setVariableWithListInsertion("{lore}", this.createItemLoreVariable(factory).get());
        lore.setVariable("{bait_theme}", Component.empty());
        return lore.getComponentListMessage();
    }

    private EMFListMessage getBaseLoreTemplate() {
        return ConfigMessage.BAIT_BAIT_LORE.getMessage().toListMessage();
    }

    @NotNull
    private EMFMessage createBoostsVariable() {
        EMFSingleMessage boostsMessage = EMFSingleMessage.empty();
        this.appendRarityBoosts(boostsMessage);
        this.appendFishBoosts(boostsMessage);
        return boostsMessage;
    }

    private void appendRarityBoosts(EMFMessage message) {
        if (this.rarities.isEmpty()) {
            return;
        }
        ConfigMessage boostMessage = this.rarities.size() > 1 ? ConfigMessage.BAIT_BOOSTS_RARITIES : ConfigMessage.BAIT_BOOSTS_RARITY;
        message.appendMessage(boostMessage.getMessage());
        message.setAmount(Integer.toString(this.rarities.size()));
    }

    private void appendFishBoosts(EMFMessage message) {
        if (this.fish.isEmpty()) {
            return;
        }
        message.appendMessage(ConfigMessage.BAIT_BOOSTS_FISH.getMessage());
        message.setAmount(Integer.toString(this.fish.size()));
    }

    @Contract(pure=true)
    @NotNull
    private Supplier<EMFListMessage> createItemLoreVariable(ItemFactory factory) {
        return () -> EMFListMessage.fromStringList(factory.getLore().getConfiguredValue());
    }
}

