/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.competition.CompetitionStrategy;
import com.oheers.fish.competition.strategies.LargestFishStrategy;
import com.oheers.fish.competition.strategies.LargestTotalStrategy;
import com.oheers.fish.competition.strategies.MostFishStrategy;
import com.oheers.fish.competition.strategies.RandomStrategy;
import com.oheers.fish.competition.strategies.ShortestFishStrategy;
import com.oheers.fish.competition.strategies.ShortestTotalStrategy;
import com.oheers.fish.competition.strategies.SpecificFishStrategy;
import com.oheers.fish.competition.strategies.SpecificRarityStrategy;
import com.oheers.fish.messages.ConfigMessage;
import org.jetbrains.annotations.Nullable;

public enum CompetitionType {
    LARGEST_FISH(ConfigMessage.COMPETITION_TYPE_LARGEST, "Largest Fish", false, new LargestFishStrategy()),
    SPECIFIC_FISH(ConfigMessage.COMPETITION_TYPE_SPECIFIC, "Specific Fish", false, new SpecificFishStrategy()),
    MOST_FISH(ConfigMessage.COMPETITION_TYPE_MOST, "Most Fish", false, new MostFishStrategy()),
    SPECIFIC_RARITY(ConfigMessage.COMPETITION_TYPE_SPECIFIC_RARITY, "Specific Rarity", false, new SpecificRarityStrategy()),
    LARGEST_TOTAL(ConfigMessage.COMPETITION_TYPE_LARGEST_TOTAL, "Largest Total", false, new LargestTotalStrategy()),
    RANDOM(ConfigMessage.COMPETITION_TYPE_LARGEST, "Random", false, new RandomStrategy()),
    SHORTEST_FISH(ConfigMessage.COMPETITION_TYPE_SHORTEST, "Shortest Fish", true, new ShortestFishStrategy()),
    SHORTEST_TOTAL(ConfigMessage.COMPETITION_TYPE_SHORTEST_TOTAL, "Shortest Total", true, new ShortestTotalStrategy());

    private final ConfigMessage typeVariable;
    private final String barPrefix;
    private final boolean shouldReverseLeaderboard;
    private final CompetitionStrategy strategy;

    private CompetitionType(ConfigMessage typeVariable, String barPrefix, boolean shouldReverseLeaderboard, CompetitionStrategy strategy) {
        this.typeVariable = typeVariable;
        this.barPrefix = barPrefix;
        this.shouldReverseLeaderboard = shouldReverseLeaderboard;
        this.strategy = strategy;
    }

    public ConfigMessage getTypeVariable() {
        return this.typeVariable;
    }

    public String getBarPrefix() {
        return this.barPrefix;
    }

    public boolean shouldReverseLeaderboard() {
        return this.shouldReverseLeaderboard;
    }

    public CompetitionStrategy getStrategy() {
        return this.strategy;
    }

    @Nullable
    public static CompetitionType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return CompetitionType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }
}

