/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.data;

import com.oheers.fish.fishing.items.Fish;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FishRarityKey {
    private final String fishName;
    private final String fishRarity;

    public FishRarityKey(String fishName, String fishRarity) {
        this.fishName = fishName;
        this.fishRarity = fishRarity;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static FishRarityKey of(String fishName, String fishRarity) {
        return new FishRarityKey(fishName, fishRarity);
    }

    @NotNull
    public static FishRarityKey from(String pattern) {
        if (pattern.length() == 1) {
            return FishRarityKey.empty();
        }
        return new FishRarityKey(pattern.split("\\.")[0], pattern.split("\\.")[1]);
    }

    @NotNull
    public static FishRarityKey of(@NotNull Fish fish) {
        return new FishRarityKey(fish.getName(), fish.getRarity().getId());
    }

    @NotNull
    public static FishRarityKey empty() {
        return new FishRarityKey("", "");
    }

    public String getFishName() {
        return this.fishName;
    }

    public String getFishRarity() {
        return this.fishRarity;
    }

    public String toString() {
        return this.fishName + "." + this.fishRarity;
    }

    public String toStringDefault() {
        return "FishRarityKey{fishName='" + this.fishName + "', fishRarity='" + this.fishRarity + "'}";
    }
}

