/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.data.manager;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.database.Database;
import com.oheers.fish.database.model.user.EmptyUserReport;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class UserManager
implements Listener {
    private final Database database;
    private final Map<UUID, Integer> userCache;

    public UserManager(Database database) {
        this.database = database;
        this.userCache = new ConcurrentHashMap<UUID, Integer>();
    }

    @EventHandler
    public void onJoin(@NotNull PlayerJoinEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        int id = this.database.getUserId(uuid);
        if (id == 0) {
            EvenMoreFish.getInstance().getPluginDataManager().getDatabase().upsertUserReport(new EmptyUserReport(event.getPlayer().getUniqueId()));
            id = this.database.getUserId(uuid);
        }
        this.userCache.putIfAbsent(uuid, id);
        EvenMoreFish.getInstance().debug("User ID: %d UUID: %s".formatted(id, uuid));
    }

    @EventHandler
    public void onLeave(@NotNull PlayerQuitEvent event) {
        this.userCache.remove(event.getPlayer().getUniqueId());
    }

    public int getUserId(UUID uuid) {
        return this.userCache.get(uuid);
    }
}

