/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.execute;

import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.impl.DSL;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public abstract class ExecuteBase {
    private final ConnectionFactory connectionFactory;
    private final Settings settings;

    protected ExecuteBase(ConnectionFactory connectionFactory, Settings settings) {
        this.connectionFactory = connectionFactory;
        this.settings = settings;
    }

    @NotNull
    protected DSLContext getContext(Connection connection) {
        if (this.settings == null) {
            return DSL.using(connection, DatabaseUtil.getSQLDialect(this.connectionFactory.getType()));
        }
        return DSL.using(connection, DatabaseUtil.getSQLDialect(this.connectionFactory.getType()), this.settings);
    }

    protected Connection getConnection() throws SQLException {
        return this.connectionFactory.getConnection();
    }

    protected boolean supportsTransactions() {
        return this.connectionFactory.supportsTransactions();
    }
}

