/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.execute;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.database.execute.ExecuteBase;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.impl.DSL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;

public abstract class ExecuteUpdate
extends ExecuteBase {
    protected ExecuteUpdate(ConnectionFactory connectionFactory, Settings settings) {
        super(connectionFactory, settings);
    }

    public int executeUpdate() {
        int n;
        block8: {
            Connection connection = this.getConnection();
            try {
                DSLContext dslContext = this.getContext(connection);
                n = this.onRunUpdate(dslContext);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, "Update execution failed", e);
                    return 0;
                }
            }
            connection.close();
        }
        return n;
    }

    public void executeSmartUpdate() {
        if (this.supportsTransactions()) {
            this.executeInTransaction();
        } else {
            this.executeUpdate();
        }
    }

    public void executeInTransaction() {
        try (Connection connection = this.getConnection();){
            DSLContext dslContext = this.getContext(connection);
            dslContext.transaction(configuration -> {
                DSLContext transactionalDsl = DSL.using(configuration);
                this.onRunUpdate(transactionalDsl);
            });
        }
        catch (SQLException e) {
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, "Transactional update execution failed", e);
        }
    }

    protected abstract int onRunUpdate(DSLContext var1);
}

