/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.economy;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.economy.EconomyType;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.messages.EMFSingleMessage;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPointsEconomyType
implements EconomyType {
    private PlayerPointsAPI economy = null;

    public PlayerPointsEconomyType() {
        EvenMoreFish emf = EvenMoreFish.getInstance();
        emf.getLogger().log(Level.INFO, "Economy attempting to hook into PlayerPoints.");
        if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints")) {
            this.economy = PlayerPoints.getInstance().getAPI();
            emf.getLogger().log(Level.INFO, "Economy hooked into PlayerPoints.");
        }
    }

    @Override
    public String getIdentifier() {
        return "PlayerPoints";
    }

    @Override
    public double getMultiplier() {
        return MainConfig.getInstance().getEconomyMultiplier(this);
    }

    @Override
    public boolean deposit(@NotNull OfflinePlayer player, double amount, boolean allowMultiplier) {
        if (!this.isAvailable()) {
            return false;
        }
        return this.economy.give(player.getUniqueId(), (int)this.prepareValue(amount, allowMultiplier));
    }

    @Override
    public boolean withdraw(@NotNull OfflinePlayer player, double amount, boolean allowMultiplier) {
        if (!this.isAvailable()) {
            return false;
        }
        return this.economy.take(player.getUniqueId(), (int)this.prepareValue(amount, allowMultiplier));
    }

    @Override
    public boolean has(@NotNull OfflinePlayer player, double amount) {
        if (!this.isAvailable()) {
            return false;
        }
        return this.get(player) >= amount;
    }

    @Override
    public double get(@NotNull OfflinePlayer player) {
        if (!this.isAvailable()) {
            return 0.0;
        }
        return this.economy.look(player.getUniqueId());
    }

    @Override
    public double prepareValue(double value, boolean applyMultiplier) {
        if (applyMultiplier) {
            return Math.floor(value * this.getMultiplier());
        }
        return Math.floor(value);
    }

    @Override
    @Nullable
    public Component formatWorth(double totalWorth, boolean applyMultiplier) {
        if (!this.isAvailable()) {
            return null;
        }
        int worth = (int)this.prepareValue(totalWorth, applyMultiplier);
        String display = MainConfig.getInstance().getEconomyDisplay(this);
        if (display == null) {
            display = "{amount} Player Point(s)";
        }
        EMFSingleMessage message = EMFSingleMessage.fromString(display);
        message.setVariable("{amount}", String.valueOf(worth));
        return message.getComponentMessage();
    }

    @Override
    public boolean isAvailable() {
        return MainConfig.getInstance().isEconomyEnabled(this) && this.economy != null;
    }
}

