/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.util.player.UserManager;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.fishing.rods.CustomRod;
import com.oheers.fish.fishing.rods.RodManager;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Processor<E extends Event>
implements Listener {
    private final DecimalFormat decimalFormat = new DecimalFormat("#.0");

    protected abstract void process(E var1);

    protected boolean isSpaceForNewFish(Inventory inventory) {
        return inventory != null && inventory.firstEmpty() != -1;
    }

    protected boolean isCustomFishAllowed(Player player) {
        return this.isEnabled() && MainConfig.getInstance().getEnabled() && (this.competitionOnlyCheck() || EvenMoreFish.getInstance().isRaritiesCompCheckExempt()) && !EvenMoreFish.getInstance().getToggle().isCustomFishingDisabled(player);
    }

    protected abstract boolean isEnabled();

    protected Fish chooseFish(@NotNull Player player, @NotNull Location location, @Nullable BaitHandler bait, @Nullable CustomRod customRod) {
        if (bait != null && customRod == null) {
            return bait.chooseFish(player, location);
        }
        Rarity fishRarity = FishManager.getInstance().getRandomWeightedRarity(player, 1.0, Collections.emptySet(), Set.copyOf(FishManager.getInstance().getRarityMap().values()), customRod);
        if (fishRarity == null) {
            EvenMoreFish.getInstance().getLogger().severe("Could not determine a rarity for fish for " + player.getName());
            return null;
        }
        Fish fish = FishManager.getInstance().getFish(fishRarity, location, player, 1.0, null, true, this, customRod);
        if (fish == null) {
            EvenMoreFish.getInstance().getLogger().severe("Could not determine a fish for " + player.getName());
            return null;
        }
        fish.setFisherman(player.getUniqueId());
        return fish;
    }

    protected ItemStack getFish(@NotNull Player player, @NotNull Location location, @NotNull ItemStack fishingRod) {
        Fish fish;
        if (!FishUtils.checkRegion(location, MainConfig.getInstance().getAllowedRegions())) {
            return null;
        }
        if (!FishUtils.checkWorld(location)) {
            return null;
        }
        if (EvenMoreFish.getInstance().getDependencyManager().isUsingMcMMO() && ExperienceConfig.getInstance().isFishingExploitingPrevented() && UserManager.getPlayer((Player)player).getFishingManager().isExploitingFishing(location.toVector())) {
            return null;
        }
        double baitCatchPercentage = MainConfig.getInstance().getBaitCatchPercentage();
        if (this.shouldCatchBait() && baitCatchPercentage > 0.0 && EvenMoreFish.getInstance().getRandom().nextDouble() * 100.0 < baitCatchPercentage) {
            Optional<BaitHandler> caughtBait = BaitNBTManager.randomBaitCatch();
            if (caughtBait.isEmpty()) {
                EvenMoreFish.getInstance().debug(Level.WARNING, "Could not determine bait. This is usually a bug.");
                return null;
            }
            BaitHandler bait = caughtBait.get();
            EMFMessage message = ConfigMessage.BAIT_CAUGHT.getMessage();
            message.setBait(bait.format(bait.getId()));
            message.setPlayer((OfflinePlayer)player);
            message.send((Audience)player);
            return bait.create((OfflinePlayer)player);
        }
        BaitHandler applyingBait = null;
        CustomRod customRod = RodManager.getInstance().getRod(fishingRod);
        if (!(customRod != null || !BaitNBTManager.isBaitedRod(fishingRod) || MainConfig.getInstance().getBaitCompetitionDisable() && Competition.isActive())) {
            applyingBait = BaitNBTManager.randomBaitApplication(fishingRod);
        }
        if ((fish = this.chooseFish(player, location, applyingBait, customRod)) == null) {
            return null;
        }
        if (applyingBait != null) {
            applyingBait.handleFish(player, fish, fishingRod);
        }
        fish.init();
        if (!this.fireEvent(fish, player)) {
            return null;
        }
        if (fish.hasFishRewards()) {
            fish.getFishRewards().forEach(fishReward -> fishReward.rewardPlayer(player, location));
        }
        if (!fish.isSilent()) {
            String length = this.decimalFormat.format(fish.getLength());
            EMFMessage message = fish.getLength() == -1.0f ? this.getLengthlessCaughtMessage().getMessage() : this.getCaughtMessage().getMessage();
            message.setPlayer((OfflinePlayer)player);
            message.setLength(length);
            EvenMoreFish.getInstance().getMetricsManager().incrementFishCaught(1);
            fish.getDisplayName();
            message.setFishCaught(fish.getDisplayName());
            message.setRarity(fish.getRarity().getDisplayName());
            if (fish.getRarity().getAnnounce()) {
                FishUtils.broadcastFishMessage(message, player, false);
            } else {
                message.send((Audience)player);
            }
        }
        this.competitionCheck(fish, player, location);
        return fish.give();
    }

    protected abstract boolean competitionOnlyCheck();

    protected void competitionCheck(@NotNull Fish fish, @NotNull Player fisherman, @NotNull Location location) {
        World world;
        Competition active = Competition.getCurrentlyActive();
        if (active == null) {
            return;
        }
        List<World> competitionWorlds = active.getCompetitionFile().getRequiredWorlds();
        if (!(competitionWorlds.isEmpty() || (world = location.getWorld()) != null && competitionWorlds.contains(world))) {
            return;
        }
        active.applyToLeaderboard(fish, fisherman);
    }

    protected abstract boolean fireEvent(@NotNull Fish var1, @NotNull Player var2);

    protected abstract ConfigMessage getCaughtMessage();

    protected abstract ConfigMessage getLengthlessCaughtMessage();

    protected abstract boolean shouldCatchBait();

    public abstract boolean canUseFish(@NotNull Fish var1);
}

