/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing.items;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.config.ConfigUtils;
import com.oheers.fish.api.fishing.CatchType;
import com.oheers.fish.api.fishing.items.IFish;
import com.oheers.fish.api.requirement.Requirement;
import com.oheers.fish.api.reward.Reward;
import com.oheers.fish.exceptions.InvalidFishException;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.selling.WorthNBT;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fish
implements IFish {
    @NotNull
    private final Section section;
    private final String name;
    private final Rarity rarity;
    private final ItemFactory factory;
    private UUID fisherman;
    private float length;
    private List<Reward> actionRewards;
    private List<Reward> fishRewards;
    private List<Reward> sellRewards;
    private String eventType;
    @NotNull
    private Requirement requirement;
    private boolean wasBaited;
    private boolean silent;
    private double weight;
    private double minSize;
    private double maxSize;
    private boolean isCompExemptFish;
    private final boolean disableFisherman;
    private final String displayName;
    private boolean showInJournal;
    private int day = -1;
    private final double setWorth;

    private Fish(@NotNull Rarity rarity, @NotNull Section section) {
        this.section = section;
        this.rarity = rarity;
        this.name = Objects.requireNonNull(section.getNameAsString());
        this.weight = section.getDouble("weight");
        if (this.weight != 0.0) {
            rarity.setFishWeighted(true);
        }
        this.length = -1.0f;
        this.disableFisherman = section.getBoolean("disable-fisherman", Boolean.valueOf(rarity.isShouldDisableFisherman()));
        this.setWorth = section.getDouble("set-worth");
        ItemFactory factory = ItemFactory.itemFactory(section);
        factory.setFinalChanges(fish -> {
            fish.editMeta(meta -> {
                meta.displayName(this.getDisplayName().getComponentMessage());
                if (!section.getBoolean("disable-lore", Boolean.valueOf(false)).booleanValue()) {
                    meta.lore(this.getFishLore());
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ITEM_SPECIFICS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            });
            WorthNBT.setNBT(fish, this);
        });
        this.factory = factory;
        this.displayName = factory.getDisplayName().getConfiguredValue();
        this.showInJournal = section.getBoolean("journal", Boolean.valueOf(true));
        factory.getLore().setEnabled(section.getBoolean("disable-lore", Boolean.valueOf(false)) == false);
        this.setSize();
        this.checkEatEvent();
        this.checkFishEvent();
        this.checkIntEvent();
        this.checkSellEvent();
        this.checkSilent();
        this.requirement = this.loadRequirements();
    }

    public static Fish create(@NotNull Rarity rarity, @NotNull Section section) {
        return new Fish(rarity, section);
    }

    public static Fish createOrThrow(@NotNull Rarity rarity, @Nullable Section section) throws InvalidFishException {
        if (section == null) {
            throw new InvalidFishException("Fish could not be fetched from the config.");
        }
        return new Fish(rarity, section);
    }

    private Requirement loadRequirements() {
        Section requirementSection = ConfigUtils.getSectionOfMany(this.section, "requirements", "requirement");
        return new Requirement(requirementSection);
    }

    @Override
    @NotNull
    public ItemStack give(int randomIndex) {
        int initialIndex = this.factory.getRandomIndex();
        this.factory.setRandomIndex(randomIndex);
        ItemStack item = this.give();
        this.factory.setRandomIndex(initialIndex);
        return item;
    }

    @Override
    @NotNull
    public ItemStack give() {
        return this.factory.createItem(this.fisherman);
    }

    private OfflinePlayer getFishermanPlayer() {
        return this.fisherman == null ? null : Bukkit.getOfflinePlayer((UUID)this.fisherman);
    }

    private void setSize() {
        this.minSize = this.section.getDouble("size.minSize");
        this.maxSize = this.section.getDouble("size.maxSize");
        if (this.minSize == 0.0 && this.maxSize == 0.0) {
            this.minSize = this.rarity.getMinSize();
            this.maxSize = this.rarity.getMaxSize();
        }
        if (this.minSize == 0.0 && this.maxSize == 0.0 || this.minSize > this.maxSize) {
            this.minSize = 0.0;
            this.maxSize = 10.0;
        }
    }

    private void generateSize() {
        if (this.minSize < 0.0) {
            this.length = -1.0f;
        } else {
            int range = (int)((this.maxSize - this.minSize) * 10.0);
            int randomValue = EvenMoreFish.getInstance().getRandom().nextInt(range + 1);
            this.length = (float)((double)randomValue + this.minSize * 10.0) / 10.0f;
        }
    }

    @Override
    public double getWorthMultiplier() {
        return this.section.getDouble("worth-multiplier", Double.valueOf(0.0));
    }

    @Override
    public boolean hasEatRewards() {
        if (this.eventType != null) {
            return this.eventType.equals("eat");
        }
        return false;
    }

    @Override
    public boolean hasFishRewards() {
        return !this.fishRewards.isEmpty();
    }

    @Override
    public boolean hasSellRewards() {
        return !this.sellRewards.isEmpty();
    }

    @Override
    public boolean hasIntRewards() {
        if (this.eventType != null) {
            return this.eventType.equals("int");
        }
        return false;
    }

    private void checkMessage() {
        String msg = this.section.getString("message");
        if (msg == null) {
            return;
        }
        if (this.fisherman == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.fisherman);
        if (player != null) {
            EMFSingleMessage.fromString(msg).send((Audience)player);
        }
    }

    private void checkEffects() {
        String effectConfig = this.section.getString("effect");
        if (effectConfig == null) {
            return;
        }
        if (this.fisherman == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.fisherman);
        if (player == null) {
            return;
        }
        PotionEffect effect = FishUtils.getPotionEffect(effectConfig);
        if (effect == null) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 1));
            EvenMoreFish.getInstance().getLogger().warning("Invalid potion effect specified. Defaulting to Speed 2 for 5 seconds.");
            return;
        }
        EvenMoreFish.getScheduler().runTask((Entity)player, () -> player.addPotionEffect(effect));
    }

    @Override
    public void init() {
        this.generateSize();
        this.checkMessage();
        this.checkEffects();
    }

    private List<Component> getFishLore() {
        List loreOverride = this.section.getStringList("lore-override");
        EMFListMessage newLoreLine = !loreOverride.isEmpty() ? EMFListMessage.fromStringList(loreOverride) : ConfigMessage.FISH_LORE.getMessage().toListMessage();
        OfflinePlayer fishermanPlayer = this.getFishermanPlayer();
        List<String> fishLore = this.factory.getLore().getConfiguredValue();
        EMFListMessage fishLoreReplacement = fishLore.isEmpty() ? EMFListMessage.empty() : EMFListMessage.fromStringList(fishLore);
        newLoreLine.setVariableWithListInsertion("{fish_lore}", fishLoreReplacement);
        if (!this.disableFisherman && fishermanPlayer != null) {
            EMFMessage message = ConfigMessage.FISHERMAN_LORE.getMessage();
            message.setRelevantPlayer(fishermanPlayer);
            newLoreLine.setVariableWithListInsertion("{fisherman_lore}", message.toListMessage());
        } else {
            newLoreLine.setVariableWithListInsertion("{fisherman_lore}", EMFListMessage.empty());
        }
        if (this.length > 0.0f) {
            newLoreLine.setVariableWithListInsertion("{length_lore}", ConfigMessage.LENGTH_LORE.getMessage().toListMessage());
            newLoreLine.setLength(Float.toString(this.length));
        } else {
            newLoreLine.setVariableWithListInsertion("{length_lore}", EMFListMessage.empty());
        }
        newLoreLine.setRarity(this.rarity.getLorePrep());
        if (this.disableFisherman || fishermanPlayer == null) {
            return newLoreLine.getComponentListMessage();
        }
        return newLoreLine.getComponentListMessage(fishermanPlayer);
    }

    private void checkEatEvent() {
        List configRewards = this.section.getStringList("eat-event");
        if (!configRewards.isEmpty()) {
            this.eventType = "eat";
            this.actionRewards = new ArrayList<Reward>();
            configRewards.forEach(reward -> {
                reward = this.parseEventPlaceholders((String)reward);
                this.actionRewards.add(new Reward((String)reward));
            });
        }
    }

    private void checkFishEvent() {
        this.fishRewards = new ArrayList<Reward>();
        List configRewards = this.section.getStringList("catch-event");
        if (!configRewards.isEmpty()) {
            configRewards.forEach(reward -> {
                reward = this.parseEventPlaceholders((String)reward);
                this.fishRewards.add(new Reward((String)reward));
            });
        }
    }

    private void checkSellEvent() {
        this.sellRewards = new ArrayList<Reward>();
        List configRewards = this.section.getStringList("sell-event");
        if (!configRewards.isEmpty()) {
            configRewards.forEach(reward -> {
                reward = this.parseEventPlaceholders((String)reward);
                this.sellRewards.add(new Reward((String)reward));
            });
        }
    }

    private void checkIntEvent() {
        List configRewards = this.section.getStringList("interact-event");
        if (!configRewards.isEmpty()) {
            EvenMoreFish.getInstance().getEventManager().setCheckingIntEvent(true);
            this.eventType = "int";
            this.actionRewards = new ArrayList<Reward>();
            configRewards.forEach(reward -> {
                reward = this.parseEventPlaceholders((String)reward);
                this.actionRewards.add(new Reward((String)reward));
            });
        }
    }

    @Override
    public void checkSilent() {
        this.silent = this.section.getBoolean("silent", Boolean.valueOf(false));
    }

    @Override
    @NotNull
    public Fish createCopy() {
        return Fish.create(this.rarity, this.section);
    }

    @Override
    public boolean hasFishermanDisabled() {
        return this.disableFisherman;
    }

    @Override
    @Nullable
    public UUID getFisherman() {
        return this.fisherman;
    }

    @Override
    public void setFisherman(@Nullable UUID fisherman) {
        this.fisherman = fisherman;
    }

    @Override
    public boolean isCompExemptFish() {
        return this.isCompExemptFish;
    }

    @Override
    public void setCompExemptFish(boolean compExemptFish) {
        this.isCompExemptFish = compExemptFish;
    }

    @Override
    public double getSetWorth() {
        return this.setWorth;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public void setLength(Float length) {
        this.length = length == null ? -1.0f : length.floatValue();
    }

    @Override
    @NotNull
    public List<Reward> getActionRewards() {
        return this.actionRewards == null ? new ArrayList() : this.actionRewards;
    }

    @Override
    @NotNull
    public List<Reward> getFishRewards() {
        return this.fishRewards == null ? new ArrayList() : this.fishRewards;
    }

    @Override
    @NotNull
    public List<Reward> getSellRewards() {
        return this.sellRewards == null ? new ArrayList() : this.sellRewards;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @NotNull
    public EMFSingleMessage getDisplayName() {
        if (this.displayName == null) {
            return this.rarity.format(this.name);
        }
        return this.rarity.format(this.displayName);
    }

    public ItemFactory getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public Requirement getRequirement() {
        return this.requirement;
    }

    @Override
    public void setRequirement(@NotNull Requirement requirement) {
        this.requirement = requirement;
    }

    @Override
    public boolean isWasBaited() {
        return this.wasBaited;
    }

    @Override
    public void setWasBaited(boolean wasBaited) {
        this.wasBaited = wasBaited;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    private String parseEventPlaceholders(String rewardString) {
        rewardString = rewardString.replace("{length}", String.valueOf(this.length));
        String rarityReplacement = "";
        if (this.rarity != null) {
            rarityReplacement = this.rarity.getId();
        }
        rewardString = rewardString.replace("{rarity}", rarityReplacement);
        String displayNameReplacement = "";
        if (this.displayName != null) {
            displayNameReplacement = this.displayName;
        }
        rewardString = rewardString.replace("{displayname}", displayNameReplacement);
        String nameReplacement = "";
        if (this.name != null) {
            nameReplacement = this.name;
        }
        rewardString = rewardString.replace("{name}", nameReplacement);
        return rewardString;
    }

    @Override
    @NotNull
    public CatchType getCatchType() {
        String typeStr = this.section.getString("catch-type");
        if (typeStr == null) {
            return this.rarity.getCatchType();
        }
        try {
            return CatchType.valueOf(typeStr.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            EvenMoreFish.getInstance().getLogger().warning("Fish " + this.getName() + " has an incorrect catch-type. Defaulting to its rarity's catch-type.");
            return this.rarity.getCatchType();
        }
    }

    @Override
    public boolean getShowInJournal() {
        return this.showInJournal;
    }

    @Override
    public void setShowInJournal(boolean showInJournal) {
        this.showInJournal = showInJournal;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Fish)) {
            return false;
        }
        Fish fish = (Fish)other;
        return this.getRarity().equals(fish.getRarity()) && this.getName().equals(fish.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getRarity(), this.getName());
    }
}

