/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.gui;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.config.GuiFillerConfig;
import com.oheers.fish.gui.GuiUtils;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.libs.inventorygui.GuiElement;
import com.oheers.fish.libs.inventorygui.GuiStorageElement;
import com.oheers.fish.libs.inventorygui.InventoryGui;
import com.oheers.fish.libs.inventorygui.StaticGuiElement;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.utils.ItemUtils;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigGui {
    protected final Map<String, BiConsumer<ConfigGui, GuiElement.Click>> actions = GuiUtils.getActionMap();
    protected final Section config;
    protected final Player player;
    @NotNull
    private final Map<String, EMFMessage> replacements = new HashMap<String, EMFMessage>();
    private InventoryGui gui;
    private InventoryGui.CloseAction closeAction = null;

    public ConfigGui(@Nullable Section config, @NotNull HumanEntity player) {
        this.config = config;
        this.player = (Player)player;
    }

    public void addReplacement(@NotNull String variable, @NotNull String replacement) {
        this.replacements.put(variable, EMFSingleMessage.fromString(replacement));
    }

    public void addReplacement(@NotNull String variable, @NotNull Component replacement) {
        this.replacements.put(variable, EMFSingleMessage.of(replacement));
    }

    public void addReplacement(@NotNull String variable, @NotNull EMFSingleMessage replacement) {
        this.replacements.put(variable, replacement);
    }

    public void addReplacements(@NotNull Map<String, EMFSingleMessage> replacements) {
        this.replacements.putAll(replacements);
    }

    public void setCloseAction(@NotNull InventoryGui.CloseAction closeAction) {
        this.closeAction = closeAction;
    }

    @NotNull
    public InventoryGui getGui() {
        if (this.gui == null) {
            throw new IllegalStateException("ConfigGui#createGui has not been called!");
        }
        return this.gui;
    }

    public Section getGuiConfig() {
        return this.config;
    }

    public void open() {
        this.getGui().show((HumanEntity)this.player);
    }

    public void createGui() {
        if (this.config == null) {
            this.gui = new InventoryGui((Plugin)EvenMoreFish.getInstance(), "Empty Gui", new String[0], new GuiElement[0]);
            return;
        }
        String title = this.config.getString("title");
        String[] layout = (String[])this.config.getStringList("layout").stream().limit(6L).toArray(String[]::new);
        InventoryGui gui = new InventoryGui((Plugin)EvenMoreFish.getInstance(), title == null ? null : EMFSingleMessage.fromString(title).getLegacyMessage(), layout, new GuiElement[0]);
        this.loadFiller(gui, this.config);
        this.loadItems(gui, this.config);
        gui.setCloseAction(this.closeAction);
        this.gui = gui;
    }

    private void loadFiller(@NotNull InventoryGui gui, @NotNull Section config) {
        String fillerStr = config.getString("filler");
        if (fillerStr == null) {
            return;
        }
        Material filler = ItemUtils.getMaterial(fillerStr);
        if (filler == null) {
            return;
        }
        ItemStack item = new ItemStack(filler);
        item.editMeta(meta -> meta.displayName((Component)Component.empty()));
        gui.setFiller(item);
        gui.addElements(GuiFillerConfig.getInstance().getDefaultFillerItems(this));
    }

    private void loadItems(@NotNull InventoryGui gui, @NotNull Section config) {
        gui.addElements(GuiUtils.getFirstPageButton(), GuiUtils.getPreviousPageButton(), GuiUtils.getNextPageButton(), GuiUtils.getLastPageButton());
        config.getRoutesAsStrings(false).forEach(key -> {
            Section itemSection = config.getSection(key);
            if (itemSection == null || !itemSection.contains("item")) {
                return;
            }
            this.addGuiItem(gui, itemSection);
        });
    }

    protected void addGuiItem(@NotNull InventoryGui gui, @NotNull Section itemSection) {
        char character = FishUtils.getCharFromString(itemSection.getString("character", "#"), '#');
        if (character == '#') {
            return;
        }
        ItemFactory factory = ItemFactory.itemFactory(itemSection);
        ItemStack item = factory.createItem(this.player.getUniqueId(), this.replacements);
        if (item.getType() == Material.AIR) {
            return;
        }
        Section actionSection = itemSection.getSection("click-action");
        if (actionSection != null) {
            StaticGuiElement actionElement = new StaticGuiElement(character, item, click -> {
                BiConsumer<ConfigGui, GuiElement.Click> action;
                switch (click.getType()) {
                    case LEFT: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = this.actions.get(actionSection.getString("left", ""));
                        break;
                    }
                    case RIGHT: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = this.actions.get(actionSection.getString("right", ""));
                        break;
                    }
                    case MIDDLE: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = this.actions.get(actionSection.getString("middle", ""));
                        break;
                    }
                    case DROP: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = this.actions.get(actionSection.getString("drop", ""));
                        break;
                    }
                    default: {
                        BiConsumer<ConfigGui, GuiElement.Click> biConsumer = action = null;
                    }
                }
                if (action != null) {
                    action.accept(this, click);
                }
                itemSection.getStringList("click-commands").forEach(command -> Bukkit.dispatchCommand((CommandSender)click.getWhoClicked(), (String)command));
                return true;
            }, new String[0]);
            gui.addElement(actionElement);
        } else {
            StaticGuiElement element = new StaticGuiElement(character, item, click -> {
                BiConsumer<ConfigGui, GuiElement.Click> action = this.actions.get(itemSection.getString("click-action", ""));
                if (action != null) {
                    action.accept(this, click);
                }
                itemSection.getStringList("click-commands").forEach(command -> Bukkit.dispatchCommand((CommandSender)click.getWhoClicked(), (String)command));
                return true;
            }, new String[0]);
            gui.addElement(element);
        }
    }

    public void doRescue() {
        this.gui.getElements().forEach(element -> {
            if (!(element instanceof GuiStorageElement)) {
                return;
            }
            GuiStorageElement storageElement = (GuiStorageElement)element;
            Inventory inv = storageElement.getStorage();
            if (inv.isEmpty()) {
                return;
            }
            FishUtils.giveItems(inv.getStorageContents(), this.player);
            inv.clear();
        });
    }
}

