/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.gui;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.GuiConfig;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.gui.ConfigGui;
import com.oheers.fish.gui.guis.BaitsGui;
import com.oheers.fish.gui.guis.FishJournalGui;
import com.oheers.fish.gui.guis.MainMenuGui;
import com.oheers.fish.gui.guis.SellGui;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.libs.inventorygui.GuiElement;
import com.oheers.fish.libs.inventorygui.GuiPageElement;
import com.oheers.fish.libs.inventorygui.InventoryGui;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.selling.SellHelper;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuiUtils {
    public static GuiPageElement getFirstPageButton() {
        YamlDocument config = GuiConfig.getInstance().getConfig();
        return new GuiPageElement('f', GuiUtils.createItemStack(config.getSection("general.first-page")), GuiPageElement.PageAction.FIRST, new String[0]);
    }

    public static GuiPageElement getNextPageButton() {
        YamlDocument config = GuiConfig.getInstance().getConfig();
        return new GuiPageElement('n', GuiUtils.createItemStack(config.getSection("general.next-page")), GuiPageElement.PageAction.NEXT, new String[0]);
    }

    public static GuiPageElement getPreviousPageButton() {
        YamlDocument config = GuiConfig.getInstance().getConfig();
        return new GuiPageElement('p', GuiUtils.createItemStack(config.getSection("general.previous-page")), GuiPageElement.PageAction.PREVIOUS, new String[0]);
    }

    public static GuiPageElement getLastPageButton() {
        YamlDocument config = GuiConfig.getInstance().getConfig();
        return new GuiPageElement('l', GuiUtils.createItemStack(config.getSection("general.last-page")), GuiPageElement.PageAction.LAST, new String[0]);
    }

    public static ItemStack createItemStack(@Nullable Section section) {
        if (section == null) {
            ItemStack fallback = new ItemStack(Material.BARRIER);
            fallback.editMeta(meta -> meta.displayName((Component)Component.text((String)"Invalid Item")));
            return fallback;
        }
        if (section.contains("displayname")) {
            section.set("item.displayname", section.get("displayname"));
            section.remove("displayname");
        }
        ItemFactory factory = ItemFactory.itemFactory(section);
        return factory.createItem();
    }

    public static Map<String, BiConsumer<ConfigGui, GuiElement.Click>> getActionMap() {
        HashMap<String, BiConsumer<ConfigGui, GuiElement.Click>> newActionMap = new HashMap<String, BiConsumer<ConfigGui, GuiElement.Click>>();
        newActionMap.put("full-exit", (gui, click) -> {
            if (gui != null) {
                gui.doRescue();
            }
            GuiUtils.closeGui(click.getWhoClicked());
        });
        newActionMap.put("open-main-menu", (gui, click) -> {
            if (gui != null) {
                gui.doRescue();
            }
            new MainMenuGui(click.getWhoClicked()).open();
            GuiUtils.clearHistory(click.getWhoClicked());
        });
        newActionMap.put("fish-toggle", (gui, click) -> {
            HumanEntity patt3817$temp = click.getWhoClicked();
            if (patt3817$temp instanceof Player) {
                Player player = (Player)patt3817$temp;
                EvenMoreFish.getInstance().getToggle().performFishToggle(player);
            }
            click.getGui().draw();
        });
        newActionMap.put("open-shop", (gui, click) -> {
            HumanEntity humanEntity;
            if (gui != null) {
                gui.doRescue();
            }
            if (!((humanEntity = click.getWhoClicked()) instanceof Player)) {
                return;
            }
            Player player = (Player)humanEntity;
            new SellGui(player, SellGui.SellState.NORMAL, null).open();
            GuiUtils.clearHistory(click.getWhoClicked());
        });
        newActionMap.put("show-command-help", (gui, click) -> {
            click.getWhoClicked().closeInventory();
            HumanEntity patt4626$temp = click.getWhoClicked();
            if (patt4626$temp instanceof Player) {
                Player player = (Player)patt4626$temp;
                player.performCommand("%s %s".formatted(MainConfig.getInstance().getMainCommandName(), MainConfig.getInstance().getHelpSubCommandName()));
            }
        });
        newActionMap.put("sell-inventory", (gui, click) -> {
            HumanEntity humanEntity = click.getWhoClicked();
            if (!(humanEntity instanceof Player)) {
                return;
            }
            Player player = (Player)humanEntity;
            if (gui instanceof SellGui) {
                SellGui sellGui = (SellGui)gui;
                new SellGui(player, SellGui.SellState.CONFIRM, sellGui.getFishInventory()).open();
                return;
            }
            new SellHelper((Inventory)click.getWhoClicked().getInventory(), player).sellFish();
            GuiUtils.closeGui(humanEntity);
        });
        newActionMap.put("sell-shop", (gui, click) -> {
            HumanEntity humanEntity = click.getWhoClicked();
            if (gui instanceof SellGui) {
                SellGui sellGui = (SellGui)gui;
                if (humanEntity instanceof Player) {
                    Player player = (Player)humanEntity;
                    new SellGui(player, SellGui.SellState.CONFIRM, sellGui.getFishInventory()).open();
                    return;
                }
            }
            SellHelper.sellInventoryGui(click.getGui(), click.getWhoClicked());
            GuiUtils.closeGui(click.getWhoClicked());
        });
        newActionMap.put("sell-inventory-confirm", (gui, click) -> {
            HumanEntity humanEntity = click.getWhoClicked();
            if (!(humanEntity instanceof Player)) {
                return;
            }
            Player player = (Player)humanEntity;
            new SellHelper((Inventory)click.getWhoClicked().getInventory(), player).sellFish();
            if (gui != null) {
                gui.doRescue();
            }
            GuiUtils.closeGui(click.getWhoClicked());
        });
        newActionMap.put("sell-shop-confirm", (gui, click) -> {
            SellHelper.sellInventoryGui(click.getGui(), click.getWhoClicked());
            GuiUtils.closeGui(click.getWhoClicked());
        });
        newActionMap.put("open-baits-menu", (gui, click) -> {
            if (gui != null) {
                gui.doRescue();
            }
            new BaitsGui(click.getWhoClicked()).open();
            GuiUtils.clearHistory(click.getWhoClicked());
        });
        newActionMap.put("open-journal-menu", (gui, click) -> {
            if (!DatabaseUtil.isDatabaseOnline()) {
                ConfigMessage.JOURNAL_DISABLED.getMessage().send((Audience)click.getWhoClicked());
                return;
            }
            if (gui != null) {
                gui.doRescue();
            }
            new FishJournalGui(click.getWhoClicked(), null).open();
            GuiUtils.clearHistory(click.getWhoClicked());
        });
        newActionMap.put("first-page", (gui, click) -> {});
        newActionMap.put("previous-page", (gui, click) -> {});
        newActionMap.put("next-page", (gui, click) -> {});
        newActionMap.put("last-page", (gui, click) -> {});
        return newActionMap;
    }

    private static void closeGui(HumanEntity human) {
        GuiUtils.clearHistory(human);
        human.closeInventory();
    }

    private static void clearHistory(HumanEntity human) {
        InventoryGui.clearHistory(human);
    }
}

