/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.items;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.config.ConfigUtils;
import com.oheers.fish.items.ItemConfigResolver;
import com.oheers.fish.items.ItemFactoryConversion;
import com.oheers.fish.items.configs.ItemConfig;
import com.oheers.fish.utils.ItemUtils;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.NbtApiException;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFactory {
    @NotNull
    private final Section configuration;
    private boolean rawItem = false;
    private UUID relevantPlayer = null;
    private int randomIndex = -1;
    private Consumer<ItemStack> finalChanges = null;
    @NotNull
    private ItemStack baseItem;
    private final ItemConfig<Float> customModelData;
    private final ItemConfig<Integer> itemDamage;
    private final ItemConfig<String> displayName;
    private final ItemConfig<Color> dyeColour;
    private final ItemConfig<Boolean> glowing;
    private final ItemConfig<List<String>> lore;
    private final ItemConfig<PotionEffect> potionMeta;
    private final ItemConfig<Map<Enchantment, Integer>> enchantments;
    private final ItemConfig<Boolean> unbreakable;
    private final ItemConfig<Integer> quantity;
    private final ItemConfig<NamespacedKey> itemModel;

    private ItemFactory(@NotNull Section initialSection, @Nullable String configLocation) {
        this.configuration = configLocation == null ? initialSection : ConfigUtils.getOrCreateSection(initialSection, configLocation);
        new ItemFactoryConversion().performConversions(this.configuration);
        ItemConfigResolver resolver = ItemConfigResolver.getInstance();
        this.customModelData = resolver.getCustomModelData(this.configuration);
        this.itemDamage = resolver.getDamage(this.configuration);
        this.displayName = resolver.getDisplayName(this.configuration);
        this.dyeColour = resolver.getDyeColour(this.configuration);
        this.glowing = resolver.getGlowing(this.configuration);
        this.lore = resolver.getLore(this.configuration);
        this.potionMeta = resolver.getPotionMeta(this.configuration);
        this.enchantments = resolver.getEnchantments(this.configuration);
        this.unbreakable = resolver.getUnbreakable(this.configuration);
        this.quantity = resolver.getQuantity(this.configuration);
        this.itemModel = resolver.getItemModel(this.configuration);
        this.baseItem = this.getBaseItem();
    }

    public static ItemFactory itemFactory(@NotNull Section configuration) {
        return new ItemFactory(configuration, null);
    }

    public static ItemFactory itemFactory(@NotNull Section configuration, @NotNull String configLocation) {
        return new ItemFactory(configuration, configLocation);
    }

    @NotNull
    public ItemStack createItem() {
        return this.createItem((Map)null);
    }

    @NotNull
    public ItemStack createItem(@Nullable Map<String, ?> replacements) {
        ItemStack item = this.baseItem.clone();
        if (!this.rawItem) {
            this.customModelData.apply(item, replacements);
            this.itemDamage.apply(item, replacements);
            this.displayName.apply(item, replacements);
            this.dyeColour.apply(item, replacements);
            this.glowing.apply(item, replacements);
            this.lore.apply(item, replacements);
            this.potionMeta.apply(item, replacements);
            this.enchantments.apply(item, replacements);
            this.unbreakable.apply(item, replacements);
            this.quantity.apply(item, replacements);
            this.itemModel.apply(item, replacements);
            if (this.finalChanges != null) {
                this.finalChanges.accept(item);
            }
        }
        return item;
    }

    @NotNull
    public ItemStack createItem(@NotNull UUID relevantPlayer) {
        this.relevantPlayer = relevantPlayer;
        return this.createItem();
    }

    @NotNull
    public ItemStack createItem(@NotNull UUID relevantPlayer, @Nullable Map<String, ?> replacements) {
        this.relevantPlayer = relevantPlayer;
        return this.createItem(replacements);
    }

    @NotNull
    public ItemStack getBaseItem() {
        ItemStack rawNbt = this.checkRawNbt();
        if (rawNbt != null) {
            this.rawItem = true;
            return rawNbt;
        }
        ItemStack material = this.checkMaterial();
        if (material != null) {
            return material;
        }
        ItemStack rawMaterial = this.checkRawMaterial();
        if (rawMaterial != null) {
            this.rawItem = true;
            return rawMaterial;
        }
        ItemStack randomMaterial = this.checkRandomMaterial();
        if (randomMaterial != null) {
            return randomMaterial;
        }
        ItemStack headDB = this.checkHeadDB();
        if (headDB != null) {
            return headDB;
        }
        ItemStack randomHeadDB = this.checkRandomHeadDB();
        if (randomHeadDB != null) {
            return randomHeadDB;
        }
        ItemStack head64 = this.checkHead64();
        if (head64 != null) {
            return head64;
        }
        ItemStack randomHead64 = this.checkRandomHead64();
        if (randomHead64 != null) {
            return randomHead64;
        }
        ItemStack headUUID = this.checkHeadUUID();
        if (headUUID != null) {
            return headUUID;
        }
        ItemStack randomHeadUUID = this.checkRandomHeadUUID();
        if (randomHeadUUID != null) {
            return randomHeadUUID;
        }
        ItemStack ownHead = this.checkOwnHead();
        if (ownHead != null) {
            return ownHead;
        }
        EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has no valid item, returning default.");
        return new ItemStack(Material.COD);
    }

    public ItemConfig<Float> getCustomModelData() {
        return this.customModelData;
    }

    public ItemConfig<Integer> getItemDamage() {
        return this.itemDamage;
    }

    public ItemConfig<String> getDisplayName() {
        return this.displayName;
    }

    public ItemConfig<Color> getDyeColour() {
        return this.dyeColour;
    }

    public ItemConfig<Boolean> getGlowing() {
        return this.glowing;
    }

    public ItemConfig<List<String>> getLore() {
        return this.lore;
    }

    public ItemConfig<PotionEffect> getPotionMeta() {
        return this.potionMeta;
    }

    public ItemConfig<Map<Enchantment, Integer>> getEnchantments() {
        return this.enchantments;
    }

    public ItemConfig<Boolean> getUnbreakable() {
        return this.unbreakable;
    }

    public ItemConfig<Integer> getQuantity() {
        return this.quantity;
    }

    public ItemConfig<NamespacedKey> getItemModel() {
        return this.itemModel;
    }

    @Nullable
    private ItemStack checkRawNbt() {
        String rawValue = this.configuration.getString("item.raw-nbt");
        if (rawValue == null) {
            return null;
        }
        try {
            return NBT.itemStackFromNBT(NBT.parseNBT(rawValue));
        }
        catch (NbtApiException exception) {
            EvenMoreFish.getInstance().getLogger().severe(this.configuration.getRouteAsString() + " has invalid raw NBT: " + rawValue);
            return null;
        }
    }

    @Nullable
    private ItemStack getItemFromMaterialString(@NotNull String materialString) {
        Material material = ItemUtils.getMaterial(materialString);
        if (material != null) {
            return new ItemStack(material);
        }
        EvenMoreFish.getInstance().debug(materialString + " is not a valid material, checking for custom item.");
        ItemStack customItem = FishUtils.getItem(materialString);
        if (customItem != null) {
            return customItem;
        }
        EvenMoreFish.getInstance().getLogger().severe("Could not find material or custom item for: " + materialString);
        return null;
    }

    @Nullable
    private ItemStack checkMaterial() {
        String materialStr = this.configuration.getString("item.material");
        if (materialStr == null) {
            return null;
        }
        return this.getItemFromMaterialString(materialStr);
    }

    @Nullable
    private ItemStack checkRandomMaterial() {
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.materials"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return this.getItemFromMaterialString((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, this::getItemFromMaterialString);
    }

    @Nullable
    private ItemStack checkRawMaterial() {
        String materialStr = this.configuration.getString("item.raw-material");
        if (materialStr == null) {
            return null;
        }
        return this.getItemFromMaterialString(materialStr);
    }

    @Nullable
    private ItemStack checkHeadDB() {
        if (!EvenMoreFish.getInstance().getDependencyManager().isUsingHeadsDB()) {
            return null;
        }
        String materialStr = this.configuration.getString("item.headdb");
        if (materialStr == null) {
            return null;
        }
        ItemStack item = EvenMoreFish.getInstance().getDependencyManager().getHdbapi().getItemHead(materialStr);
        if (item == null) {
            EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has invalid headdb: " + materialStr);
            return null;
        }
        return item;
    }

    @Nullable
    private ItemStack checkRandomHeadDB() {
        if (!EvenMoreFish.getInstance().getDependencyManager().isUsingHeadsDB()) {
            return null;
        }
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.multiple-headdb"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return EvenMoreFish.getInstance().getDependencyManager().getHdbapi().getItemHead((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, arg_0 -> ((HeadDatabaseAPI)EvenMoreFish.getInstance().getDependencyManager().getHdbapi()).getItemHead(arg_0));
    }

    @Nullable
    private ItemStack checkHead64() {
        String materialStr = this.configuration.getString("item.head-64");
        if (materialStr == null) {
            return null;
        }
        return FishUtils.getSkullFromBase64(materialStr);
    }

    @Nullable
    private ItemStack checkRandomHead64() {
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.multiple-head-64"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return FishUtils.getSkullFromBase64((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, FishUtils::getSkullFromBase64);
    }

    @Nullable
    private ItemStack checkHeadUUID() {
        String materialStr = this.configuration.getString("item.head-uuid");
        if (materialStr == null) {
            return null;
        }
        return FishUtils.getSkullFromUUIDString(materialStr);
    }

    @Nullable
    private ItemStack checkRandomHeadUUID() {
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.multiple-head-uuid"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return FishUtils.getSkullFromUUIDString((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, FishUtils::getSkullFromUUIDString);
    }

    @Nullable
    private ItemStack checkOwnHead() {
        if (this.relevantPlayer == null) {
            return null;
        }
        String materialStr = this.configuration.getString("item.own-head");
        if (materialStr == null) {
            return null;
        }
        return FishUtils.getSkullFromUUID(this.relevantPlayer);
    }

    @Nullable
    private ItemStack getRandomItem(@NotNull List<String> strings, @NotNull Function<String, ItemStack> function) {
        if (this.randomIndex != -1) {
            EvenMoreFish.getInstance().debug("Random index is set to " + this.randomIndex + ", trying to use it.");
            try {
                String randomStr = strings.get(this.randomIndex);
                ItemStack randomItem = function.apply(randomStr);
                if (randomItem != null) {
                    return randomItem;
                }
            }
            catch (IndexOutOfBoundsException exception) {
                EvenMoreFish.getInstance().debug("Random index " + this.randomIndex + " is out of bounds, getting a new one.");
            }
        }
        ArrayList<String> checkList = new ArrayList<String>(strings);
        Random random = EvenMoreFish.getInstance().getRandom();
        while (!checkList.isEmpty()) {
            int randomIndex = random.nextInt(checkList.size());
            String randomStr = checkList.remove(randomIndex);
            ItemStack randomItem = function.apply(randomStr);
            if (randomItem != null) {
                this.randomIndex = randomIndex;
                return randomItem;
            }
            EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has an invalid name in its list: " + randomStr);
        }
        EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has no valid items in its list.");
        return null;
    }

    public boolean isRawItem() {
        return this.rawItem;
    }

    public void setRandomIndex(int randomIndex) {
        this.randomIndex = randomIndex;
        this.baseItem = this.getBaseItem();
    }

    public int getRandomIndex() {
        return this.randomIndex;
    }

    public void setFinalChanges(@Nullable Consumer<ItemStack> finalChanges) {
        this.finalChanges = finalChanges;
    }
}

